/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Name;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.PolicyValueFactory;
import org.nhindirect.policy.x509.AbstractTBSField;
import org.nhindirect.policy.x509.RDNAttributeIdentifier;
import org.nhindirect.policy.x509.TBSFieldName;

public class IssuerAttributeField
extends AbstractTBSField<Collection<String>> {
    static final long serialVersionUID = -8303963586265595510L;
    protected final RDNAttributeIdentifier rdnAttributeId;

    public IssuerAttributeField(boolean required, RDNAttributeIdentifier rdnAttributeId) {
        super(required);
        this.rdnAttributeId = rdnAttributeId;
    }

    @Override
    public TBSFieldName getFieldName() {
        return TBSFieldName.ISSUER;
    }

    @Override
    public void injectReferenceValue(X509Certificate value) throws PolicyProcessException {
        this.certificate = value;
        if (this.rdnAttributeId.equals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME)) {
            List<String> str = Arrays.asList(this.certificate.getIssuerX500Principal().getName("RFC2253"));
            this.policyValue = PolicyValueFactory.getInstance(str);
            return;
        }
        DERObject tbsValue = null;
        try {
            tbsValue = this.getDERObject(this.certificate.getTBSCertificate());
        }
        catch (Exception e) {
            throw new PolicyProcessException("Exception parsing TBS certificate fields.", e);
        }
        TBSCertificateStructure tbsStruct = TBSCertificateStructure.getInstance((Object)tbsValue);
        X509Name x509Name = this.getX509Name(tbsStruct);
        Vector values = x509Name.getValues(new DERObjectIdentifier(this.getRDNAttributeFieldId().getId()));
        if (values.isEmpty() && this.isRequired()) {
            throw new PolicyRequiredException((Object)((Object)this.getFieldName()) + " field attribute " + this.rdnAttributeId.getName() + " is marked as required but is not present.");
        }
        Vector retVal = values;
        this.policyValue = PolicyValueFactory.getInstance(retVal);
    }

    protected X509Name getX509Name(TBSCertificateStructure tbsStruct) {
        return tbsStruct.getIssuer();
    }

    public RDNAttributeIdentifier getRDNAttributeFieldId() {
        return this.rdnAttributeId;
    }
}

