/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import org.nhindirect.policy.IntegerPolicyOperatorExecutor;
import org.nhindirect.policy.PolicyOperator;
import org.nhindirect.policy.PolicyValue;
import org.nhindirect.policy.PolicyValueFactory;

public class BinaryIntegerPolicyOperatorExecutor<O1, O2>
implements IntegerPolicyOperatorExecutor<O1> {
    protected final PolicyValue<O1> operand1;
    protected final PolicyValue<O2> operand2;
    protected final PolicyOperator operator;

    public BinaryIntegerPolicyOperatorExecutor(PolicyValue<O1> operand1, PolicyValue<O2> operand2, PolicyOperator operator) {
        if (!operator.equals((Object)PolicyOperator.BITWISE_AND) && !operator.equals((Object)PolicyOperator.BITWISE_OR)) {
            throw new IllegalArgumentException("Operator " + operator.getOperatorText() + " is not allowed for this executor type.");
        }
        this.operand1 = operand1;
        this.operand2 = operand2;
        this.operator = operator;
    }

    @Override
    public PolicyValue<Integer> execute() {
        int retVal = 0;
        switch (this.operator) {
            case BITWISE_AND: 
            case BITWISE_OR: {
                int int1 = (Integer)Integer.class.cast(this.operand1.getPolicyValue());
                int int2 = (Integer)Integer.class.cast(this.operand2.getPolicyValue());
                if (this.operator.equals((Object)PolicyOperator.BITWISE_AND)) {
                    retVal = int1 & int2;
                    break;
                }
                retVal = int1 | int2;
                break;
            }
            default: {
                retVal = 0;
            }
        }
        return PolicyValueFactory.getInstance(retVal);
    }
}

