/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nhindirect.policy.BooleanPolicyOperatorExecutor;
import org.nhindirect.policy.PolicyOperator;
import org.nhindirect.policy.PolicyValue;
import org.nhindirect.policy.PolicyValueFactory;

public class BinaryBooleanPolicyOperatorExecutor<O1, O2>
implements BooleanPolicyOperatorExecutor<O1> {
    protected final PolicyValue<O1> operand1;
    protected final PolicyValue<O2> operand2;
    protected final PolicyOperator operator;

    public BinaryBooleanPolicyOperatorExecutor(PolicyValue<O1> operand1, PolicyValue<O2> operand2, PolicyOperator operator) {
        if (!(operator.equals((Object)PolicyOperator.LOGICAL_AND) || operator.equals((Object)PolicyOperator.LOGICAL_OR) || operator.equals((Object)PolicyOperator.EQUALS) || operator.equals((Object)PolicyOperator.NOT_EQUALS) || operator.equals((Object)PolicyOperator.REG_EX) || operator.equals((Object)PolicyOperator.GREATER) || operator.equals((Object)PolicyOperator.LESS) || operator.equals((Object)PolicyOperator.CONTAINS) || operator.equals((Object)PolicyOperator.NOT_CONTAINS) || operator.equals((Object)PolicyOperator.CONTAINS_REG_EX))) {
            throw new IllegalArgumentException("Operator " + operator.getOperatorText() + " is not allowed for this executor type.");
        }
        this.operand1 = operand1;
        this.operand2 = operand2;
        this.operator = operator;
    }

    @Override
    public PolicyValue<Boolean> execute() {
        boolean retVal = false;
        switch (this.operator) {
            case EQUALS: {
                retVal = this.operand1.getPolicyValue().equals(this.operand2.getPolicyValue());
                break;
            }
            case NOT_EQUALS: {
                retVal = !this.operand1.getPolicyValue().equals(this.operand2.getPolicyValue());
                break;
            }
            case GREATER: 
            case LESS: {
                Integer op1 = (Integer)Integer.class.cast(this.operand1.getPolicyValue());
                Integer op2 = (Integer)Integer.class.cast(this.operand2.getPolicyValue());
                if (this.operator.equals((Object)PolicyOperator.GREATER)) {
                    retVal = op2 > op1;
                    break;
                }
                retVal = op2 < op1;
                break;
            }
            case CONTAINS: {
                Collection container = (Collection)Collection.class.cast(this.operand2.getPolicyValue());
                O1 value = this.operand1.getPolicyValue();
                retVal = container.contains(value);
                break;
            }
            case NOT_CONTAINS: {
                Collection container = (Collection)Collection.class.cast(this.operand2.getPolicyValue());
                O1 value = this.operand1.getPolicyValue();
                retVal = !container.contains(value);
                break;
            }
            case CONTAINS_REG_EX: {
                Object obj;
                Matcher match;
                Collection container = (Collection)Collection.class.cast(this.operand2.getPolicyValue());
                String pattern = this.operand1.getPolicyValue().toString();
                Pattern regExPatt = Pattern.compile(pattern);
                Iterator i$ = container.iterator();
                while (i$.hasNext() && !(retVal = (match = regExPatt.matcher((obj = i$.next()).toString())).find())) {
                }
                break;
            }
            case REG_EX: {
                String pattern = this.operand1.getPolicyValue().toString();
                String str = this.operand2.getPolicyValue().toString();
                Pattern regExPatt = Pattern.compile(pattern);
                Matcher match = regExPatt.matcher(str);
                retVal = match.find();
                break;
            }
            case LOGICAL_AND: 
            case LOGICAL_OR: {
                Boolean op1 = (Boolean)Boolean.class.cast(this.operand1.getPolicyValue());
                Boolean op2 = (Boolean)Boolean.class.cast(this.operand2.getPolicyValue());
                if (this.operator.equals((Object)PolicyOperator.LOGICAL_AND)) {
                    retVal = op1 != false && op2 != false;
                    break;
                }
                retVal = op1 != false || op2 != false;
                break;
            }
            default: {
                retVal = false;
            }
        }
        return PolicyValueFactory.getInstance(retVal);
    }
}

