/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import com.google.inject.Provider;
import java.util.HashMap;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.gateway.smtp.dsn.DSNCreator;
import org.nhindirect.gateway.smtp.dsn.provider.FailedDeliveryDSNCreatorProvider;
import org.nhindirect.gateway.smtp.james.mailet.AbstractNotificationAwareMailet;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.options.OptionsManager;

public class TrackIncomingNotification
extends AbstractNotificationAwareMailet {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(TrackIncomingNotification.class);

    private static synchronized void initJVMParams() {
        HashMap<String, String> JVM_PARAMS = new HashMap<String, String>();
        JVM_PARAMS.put("MessageMonitoringServiceURL", "org.nhindirect.gateway.smtp.james.mailet.TxServiceURL");
        OptionsManager.addInitParameters(JVM_PARAMS);
    }

    @Override
    public void init() throws MessagingException {
        super.init();
    }

    public void service(Mail mail) throws MessagingException {
        LOGGER.debug((Object)"Calling track incoming notification service");
        MimeMessage msg = mail.getMessage();
        NHINDAddressCollection recipients = this.getMailRecipients(mail);
        NHINDAddress sender = this.getMailSender(mail);
        Tx txToMonitor = this.getTxToTrack(msg, sender, recipients);
        if (txToMonitor != null && (txToMonitor.getMsgType() == TxMessageType.DSN || txToMonitor.getMsgType() == TxMessageType.MDN)) {
            try {
                this.txService.trackMessage(txToMonitor);
            }
            catch (ServiceException ex) {
                LOGGER.warn((Object)"Failed to submit message to monitoring service.", (Throwable)ex);
            }
        }
        LOGGER.debug((Object)"Exiting track incoming notification service");
    }

    @Override
    protected Provider<DSNCreator> getDSNProvider() {
        return new FailedDeliveryDSNCreatorProvider((Mailet)this);
    }

    static {
        TrackIncomingNotification.initJVMParams();
    }
}

