/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.james.mailet;

import com.google.inject.Provider;
import java.util.HashMap;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.gateway.GatewayConfiguration;
import org.nhindirect.gateway.smtp.dsn.DSNCreator;
import org.nhindirect.gateway.smtp.james.mailet.AbstractNotificationAwareMailet;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.options.OptionsManager;

public class NotificationSuppressor
extends AbstractNotificationAwareMailet {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(NotificationSuppressor.class);
    protected boolean consumeMDNProcessed;

    private static synchronized void initJVMParams() {
        HashMap<String, String> JVM_PARAMS = new HashMap<String, String>();
        JVM_PARAMS.put("ConsumeMDNProcessed", "org.nhindirect.gateway.smtp.james.mailet.ConsumeMDNProcessed");
        OptionsManager.addInitParameters(JVM_PARAMS);
    }

    @Override
    public void init() throws MessagingException {
        LOGGER.info((Object)"Initializing NotificationSupressor");
        super.init();
        this.consumeMDNProcessed = GatewayConfiguration.getConfigurationParamAsBoolean("ConsumeMDNProcessed", (Mailet)this, false);
        LOGGER.info((Object)"NotificationSupressor initialization complete.");
    }

    public void service(Mail mail) throws MessagingException {
        boolean suppress = false;
        MimeMessage msg = mail.getMessage();
        NHINDAddressCollection recipients = this.getMailRecipients(mail);
        NHINDAddress sender = this.getMailSender(mail);
        Tx txToTrack = this.getTxToTrack(msg, sender, recipients);
        if (txToTrack != null) {
            try {
                TxDetail detail = txToTrack.getDetail(TxDetailType.DISPOSITION);
                if (this.consumeMDNProcessed && txToTrack.getMsgType() == TxMessageType.MDN && detail != null && detail.getDetailValue().contains("processed")) {
                    suppress = true;
                } else if (this.txService != null && txToTrack != null && this.txService.suppressNotification(txToTrack)) {
                    suppress = true;
                }
            }
            catch (ServiceException e) {
                LOGGER.warn((Object)"Failed to get notification suppression status from service.  Message will assume to not need supressing.");
            }
        }
        if (suppress) {
            mail.setState("ghost");
        }
    }

    @Override
    protected Provider<DSNCreator> getDSNProvider() {
        return null;
    }

    static {
        NotificationSuppressor.initJVMParams();
    }
}

