/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.gateway.smtp.SmtpAgent;
import org.nhindirect.gateway.smtp.SmtpAgentError;
import org.nhindirect.gateway.smtp.SmtpAgentException;
import org.nhindirect.gateway.smtp.config.SmptAgentConfigFactory;
import org.nhindirect.gateway.smtp.config.SmtpAgentConfig;
import org.nhindirect.stagent.NHINDAgent;

public class SmtpAgentFactory {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(SmtpAgentFactory.class);

    public static synchronized SmtpAgent createAgent(URL configLocation) throws SmtpAgentException {
        return SmtpAgentFactory.createAgent(configLocation, null, null, null);
    }

    public static synchronized SmtpAgent createAgent(URL configLocation, Provider<SmtpAgentConfig> configProvider, Provider<NHINDAgent> agentProvider) throws SmtpAgentException {
        return SmtpAgentFactory.createAgent(configLocation, configProvider, agentProvider, null);
    }

    public static synchronized SmtpAgent createAgent(URL configLocation, Provider<SmtpAgentConfig> configProvider, Provider<NHINDAgent> agentProvider, Collection<? extends Module> modules) throws SmtpAgentException {
        SmtpAgent retVal = null;
        try {
            Injector agentInjector = SmtpAgentFactory.buildAgentInjector(configLocation, configProvider, agentProvider);
            if (modules != null && modules.size() > 0) {
                agentInjector = agentInjector.createChildInjector(modules);
            }
            retVal = (SmtpAgent)agentInjector.getInstance(SmtpAgent.class);
            agentInjector.injectMembers((Object)retVal);
        }
        catch (SmtpAgentException e) {
            throw e;
        }
        catch (Exception t) {
            LOGGER.error((Object)("SmtpAgent creation failed: " + t.getMessage()), (Throwable)t);
            throw new SmtpAgentException(SmtpAgentError.Unknown, "SmtpAgent creation failed: " + t.getMessage(), t);
        }
        catch (Throwable t) {
            LOGGER.error((Object)("SmtpAgent creation failed: " + t.getMessage()), t);
            throw new SmtpAgentException(SmtpAgentError.Unknown, "SmtpAgent creation failed: " + t.getMessage());
        }
        return retVal;
    }

    protected static Injector buildAgentInjector(URL configLocation, Provider<SmtpAgentConfig> configProvider, Provider<NHINDAgent> agentProvider) {
        SmtpAgentConfig config = SmptAgentConfigFactory.createSmtpAgentConfig(configLocation, configProvider, agentProvider);
        return config.getAgentInjector();
    }
}

