/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.nhindirect.gateway.smtp.SmtpAgentError;
import org.nhindirect.gateway.smtp.SmtpAgentException;

public class DomainPostmaster {
    private static final String DEFAULT_POSTMASTER_ACCOUNT = "postmaster";
    private String domain;
    private InternetAddress postmaster;

    public DomainPostmaster() {
        this.domain = "";
        this.postmaster = new InternetAddress();
    }

    public DomainPostmaster(String domain, InternetAddress postmaster) {
        if (domain == null) {
            throw new IllegalArgumentException();
        }
        this.domain = domain;
        try {
            this.postmaster = postmaster != null ? postmaster : new InternetAddress(DomainPostmaster.getDefaultPostmaster(domain));
        }
        catch (AddressException e) {
            throw new SmtpAgentException(SmtpAgentError.MissingPostmaster, "Invalid postmaster address format", (Exception)((Object)e));
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public InternetAddress getPostmaster() {
        return this.postmaster;
    }

    public void setPostmasters(InternetAddress postmaster) {
        this.postmaster = postmaster;
    }

    public static String getDefaultPostmaster(String domain) {
        StringBuilder builder = new StringBuilder(DEFAULT_POSTMASTER_ACCOUNT).append("@").append(domain);
        return builder.toString();
    }
}

