/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.resources;

import com.google.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.monitor.processor.DuplicateNotificationStateManager;
import org.nhindirect.monitor.processor.DuplicateNotificationStateManagerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="txs/")
@Singleton
public class TxsResource {
    protected static final CacheControl noCache;
    private static final Log LOGGER;
    @Autowired
    protected ProducerTemplate template;
    @Autowired
    protected DuplicateNotificationStateManager dupStateManager;

    public TxsResource() {
    }

    public TxsResource(ProducerTemplate template, DuplicateNotificationStateManager dupMgr) {
        this.template = template;
        this.dupStateManager = dupMgr;
    }

    @TypeHint(value=Tx.class)
    @POST
    @Consumes(value={"application/json"})
    public Response addTx(Tx tx) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"Attempting to add Tx");
        }
        if (this.template == null) {
            throw new IllegalStateException("Template producer cannot be null.  Please examine the txs resource configuration");
        }
        try {
            this.template.sendBody((Object)tx);
        }
        catch (Throwable t) {
            LOGGER.error((Object)"Failed to add Tx message", t);
            return Response.serverError().cacheControl(noCache).build();
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"Tx added");
        }
        return Response.status((Response.Status)Response.Status.CREATED).cacheControl(noCache).build();
    }

    @Path(value="suppressNotification")
    @TypeHint(value=Boolean.class)
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response supressNotification(Tx notificationMessage) {
        if (this.dupStateManager == null) {
            throw new IllegalStateException("Duplicatoin state manager cannot be null.  Please examine the txs resource configuration");
        }
        try {
            Boolean retEntity = this.dupStateManager.suppressNotification(notificationMessage);
            return Response.ok((Object)retEntity).cacheControl(noCache).build();
        }
        catch (DuplicateNotificationStateManagerException e) {
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    static {
        LOGGER = LogFactory.getFactory().getInstance(TxsResource.class);
        noCache = new CacheControl();
        noCache.setNoCache(true);
    }
}

