/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.processor.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.MimeMessage;
import org.apache.camel.Exchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.common.tx.TxUtil;
import org.nhindirect.common.tx.impl.DefaultTxDetailParser;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.condition.impl.AbstractCompletionCondition;
import org.nhindirect.monitor.dao.NotificationDAOException;
import org.nhindirect.monitor.processor.DuplicateNotificationStateManagerException;
import org.nhindirect.monitor.processor.impl.DefaultDuplicateNotificationStateManager;

public class TimeoutDupStateManager
extends DefaultDuplicateNotificationStateManager {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(TimeoutDupStateManager.class);
    protected final DefaultTxDetailParser parser = new DefaultTxDetailParser();

    public void addNotificationForOriginalRecips(Collection<Tx> txs) throws DuplicateNotificationStateManagerException {
        if (this.dao == null) {
            throw new IllegalArgumentException("Dao cannot be null");
        }
        if (txs == null) {
            throw new IllegalArgumentException("Txs cannot be null");
        }
        Tx tx = AbstractCompletionCondition.getMessageToTrack(txs);
        if (tx != null && TxUtil.isReliableAndTimelyRequested((Tx)tx)) {
            TxDetail recipDetail = tx.getDetail(TxDetailType.RECIPIENTS);
            TxDetail msgId = tx.getDetail(TxDetailType.MSG_ID);
            if (recipDetail != null && msgId != null) {
                String[] recips;
                for (String recip : recips = recipDetail.getDetailValue().split(",")) {
                    try {
                        String normalizedFinalRecip = AbstractCompletionCondition.normalizeFinalRecip(recip);
                        this.dao.addNotification(msgId.getDetailValue(), normalizedFinalRecip);
                    }
                    catch (NotificationDAOException e) {
                        LOGGER.warn((Object)("Can't add recipient " + recip + " for message id " + msgId.getDetailValue() + " to dup store.  Possibly already exists in dup store."));
                    }
                }
            }
        }
    }

    public void addNotificationForMonitorGeneratedDSN(MimeMessage dsnMessage, Exchange ex) throws DuplicateNotificationStateManagerException {
        if (this.dao == null) {
            throw new IllegalArgumentException("Dao cannot be null");
        }
        if (dsnMessage == null) {
            throw new IllegalArgumentException("DSN message cannot be null");
        }
        if (TxUtil.getMessageType((MimeMessage)dsnMessage).equals((Object)TxMessageType.DSN) && ex.getProperty("ORIG_IS_TIMELY") != null) {
            Map details = this.parser.getMessageDetails(dsnMessage);
            TxDetail origMsgId = (TxDetail)details.get(TxDetailType.PARENT_MSG_ID.getType());
            TxDetail finalRecipDetail = (TxDetail)details.get(TxDetailType.FINAL_RECIPIENTS.getType());
            TxDetail msgId = (TxDetail)details.get(TxDetailType.MSG_ID.getType());
            if (origMsgId != null && finalRecipDetail != null && msgId != null) {
                String[] finalRecips;
                for (String finalRecip : finalRecips = finalRecipDetail.getDetailValue().split(",")) {
                    try {
                        String normalizedFinalRecip = AbstractCompletionCondition.normalizeFinalRecip(finalRecip);
                        String addMsgId = origMsgId.getDetailValue() + "\t" + msgId.getDetailValue();
                        this.dao.addNotification(addMsgId, normalizedFinalRecip);
                        this.dao.addNotification(origMsgId.getDetailValue(), normalizedFinalRecip);
                    }
                    catch (NotificationDAOException e) {
                        LOGGER.warn((Object)("Can't add recipient " + finalRecip + " for message id " + msgId.getDetailValue() + " to dup store.  Possibly already exists in dup store."));
                    }
                }
            }
        }
    }

    @Override
    public boolean suppressNotification(Tx notificationMessage) throws DuplicateNotificationStateManagerException {
        boolean retVal = false;
        if (this.dao == null) {
            throw new IllegalArgumentException("Dao cannot be null");
        }
        if (notificationMessage == null) {
            throw new IllegalArgumentException("Notification message cannot be null");
        }
        TxMessageType type = notificationMessage.getMsgType();
        if (type == TxMessageType.DSN || type == TxMessageType.MDN) {
            TxDetail dispositionDetail = notificationMessage.getDetail(TxDetailType.DISPOSITION);
            if (type == TxMessageType.MDN && (dispositionDetail == null || dispositionDetail.getDetailValue().contains("displayed"))) {
                return retVal;
            }
            TxDetail originalMessageIdDetail = notificationMessage.getDetail(TxDetailType.PARENT_MSG_ID);
            TxDetail origRecips = notificationMessage.getDetail(TxDetailType.FINAL_RECIPIENTS);
            if (originalMessageIdDetail != null && origRecips != null) {
                String[] recipsArray = origRecips.getDetailValue().split(",");
                for (int idx = 0; idx < recipsArray.length; ++idx) {
                    recipsArray[idx] = AbstractCompletionCondition.normalizeFinalRecip(recipsArray[idx]);
                }
                List<String> recips = Arrays.asList(recipsArray);
                try {
                    String queryMsgId = originalMessageIdDetail.getDetailValue() + "\t" + notificationMessage.getDetail(TxDetailType.MSG_ID).getDetailValue();
                    Set<String> alreadyReceivedNotifs = this.dao.getReceivedAddresses(queryMsgId, recips);
                    if (!alreadyReceivedNotifs.isEmpty()) {
                        retVal = false;
                    } else {
                        alreadyReceivedNotifs = this.dao.getReceivedAddresses(originalMessageIdDetail.getDetailValue(), recips);
                        if (!alreadyReceivedNotifs.isEmpty()) {
                            retVal = true;
                        }
                    }
                }
                catch (NotificationDAOException e) {
                    throw new DuplicateNotificationStateManagerException(e);
                }
            }
        }
        return retVal;
    }
}

