/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.processor.impl;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.dao.NotificationDAOException;
import org.nhindirect.monitor.dao.NotificationDuplicationDAO;
import org.nhindirect.monitor.processor.DuplicateNotificationStateManager;
import org.nhindirect.monitor.processor.DuplicateNotificationStateManagerException;

public class DefaultDuplicateNotificationStateManager
implements DuplicateNotificationStateManager {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(DefaultDuplicateNotificationStateManager.class);
    protected static final int DEFAULT_RETENTION = 7;
    protected int messageRetention = 7;
    protected NotificationDuplicationDAO dao;

    public void setMessageRetention(int messageRetention) {
        this.messageRetention = messageRetention;
    }

    public void setDao(NotificationDuplicationDAO dao) {
        this.dao = dao;
    }

    @Override
    public void addNotification(Tx notificationMessage) throws DuplicateNotificationStateManagerException {
        if (this.dao == null) {
            throw new IllegalArgumentException("Dao cannot be null");
        }
        if (notificationMessage == null) {
            throw new IllegalArgumentException("Notification message cannot be null");
        }
        TxMessageType type = notificationMessage.getMsgType();
        if (type == TxMessageType.DSN || type == TxMessageType.MDN) {
            TxDetail originalMessageIdDetail = notificationMessage.getDetail(TxDetailType.PARENT_MSG_ID);
            TxDetail origRecips = notificationMessage.getDetail(TxDetailType.FINAL_RECIPIENTS);
            if (originalMessageIdDetail != null && origRecips != null) {
                for (String recipAddress : origRecips.getDetailValue().split(",")) {
                    try {
                        this.dao.addNotification(originalMessageIdDetail.getDetailValue(), recipAddress);
                    }
                    catch (NotificationDAOException e) {
                        throw new DuplicateNotificationStateManagerException(e);
                    }
                }
            }
        }
    }

    @Override
    public boolean suppressNotification(Tx notificationMessage) throws DuplicateNotificationStateManagerException {
        boolean retVal = false;
        if (this.dao == null) {
            throw new IllegalArgumentException("Dao cannot be null");
        }
        if (notificationMessage == null) {
            throw new IllegalArgumentException("Notification message cannot be null");
        }
        TxMessageType type = notificationMessage.getMsgType();
        if (type == TxMessageType.DSN || type == TxMessageType.MDN) {
            TxDetail dispositionDetail = notificationMessage.getDetail(TxDetailType.DISPOSITION);
            if (type == TxMessageType.MDN && (dispositionDetail == null || dispositionDetail.getDetailValue().contains("displayed"))) {
                return retVal;
            }
            TxDetail originalMessageIdDetail = notificationMessage.getDetail(TxDetailType.PARENT_MSG_ID);
            TxDetail origRecips = notificationMessage.getDetail(TxDetailType.FINAL_RECIPIENTS);
            if (originalMessageIdDetail != null && origRecips != null) {
                List<String> recips = Arrays.asList(origRecips.getDetailValue().split(","));
                try {
                    Set<String> alreadyReceivedNotifs = this.dao.getReceivedAddresses(originalMessageIdDetail.getDetailValue(), recips);
                    if (!alreadyReceivedNotifs.isEmpty()) {
                        retVal = true;
                    }
                }
                catch (NotificationDAOException e) {
                    throw new DuplicateNotificationStateManagerException(e);
                }
            }
        }
        return retVal;
    }

    @Override
    public void purge() {
        if (this.dao == null) {
            throw new IllegalArgumentException("Dao cannot be null");
        }
        try {
            Calendar cal = Calendar.getInstance(Locale.getDefault());
            cal.add(10, -(24 * this.messageRetention));
            this.dao.purgeNotifications(cal);
        }
        catch (NotificationDAOException e) {
            LOGGER.warn((Object)"Message duplication state purge failed.", (Throwable)e);
        }
    }
}

