/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.expression;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;

public class MessageIdCorrelationExpression
implements Expression {
    public <String> String evaluate(Exchange exchange, Class<String> type) {
        String retVal = null;
        Tx tx = (Tx)exchange.getIn().getBody();
        TxMessageType msgType = tx.getMsgType();
        Map details = tx.getDetails();
        if (!details.isEmpty()) {
            switch (msgType) {
                case IMF: {
                    TxDetail msgIdDetail = (TxDetail)details.get(TxDetailType.MSG_ID.getType());
                    if (msgIdDetail == null) break;
                    retVal = msgIdDetail.getDetailValue().toString();
                    break;
                }
                case DSN: 
                case MDN: {
                    TxDetail msgIdDetail = (TxDetail)details.get(TxDetailType.PARENT_MSG_ID.getType());
                    if (msgIdDetail == null) break;
                    retVal = msgIdDetail.getDetailValue().toString();
                    break;
                }
            }
        }
        return (String)retVal;
    }
}

