/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.dao.impl;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.monitor.dao.NotificationDAOException;
import org.nhindirect.monitor.dao.NotificationDuplicationDAO;
import org.nhindirect.monitor.dao.entity.ReceivedNotification;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class NotificationDuplicationDAOImpl
implements NotificationDuplicationDAO {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(NotificationDuplicationDAOImpl.class);
    @PersistenceContext(unitName="direct-msg-monitor-store")
    protected EntityManager entityManager;

    protected void validateState() {
        if (this.entityManager == null) {
            throw new IllegalStateException("entityManger has not been initialized");
        }
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    @Transactional(readOnly=false)
    public void addNotification(String messageId, String address) throws NotificationDAOException {
        this.validateState();
        try {
            Set<String> notification = this.getReceivedAddresses(messageId, Arrays.asList(address));
            if (!notification.isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Notification for message id " + messageId + " and address " + address + " already received.  Not adding to received notification store."));
                }
                return;
            }
            ReceivedNotification notif = new ReceivedNotification();
            notif.setMessageid(messageId);
            notif.setAddress(address);
            notif.setReceivedTime(Calendar.getInstance(Locale.getDefault()));
            this.entityManager.persist((Object)notif);
            this.entityManager.flush();
        }
        catch (Exception e) {
            throw new NotificationDAOException("Failed to add notification to the store.", e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Set<String> getReceivedAddresses(String messageId, Collection<String> addresses) throws NotificationDAOException {
        HashSet<String> retVal;
        this.validateState();
        if (addresses == null || addresses.size() == 0) {
            return Collections.emptySet();
        }
        if (messageId == null || messageId.isEmpty()) {
            return Collections.emptySet();
        }
        StringBuffer ids = new StringBuffer("(");
        for (String tp : addresses) {
            if (ids.length() > 1) {
                ids.append(", ");
            }
            ids.append("'").append(tp.toLowerCase(Locale.getDefault())).append("'");
        }
        ids.append(")");
        try {
            String query = "SELECT address from ReceivedNotification rn WHERE rn.messageid = ?1 and rn.address IN " + ids.toString();
            Query select = this.entityManager.createQuery(query);
            select.setParameter(1, (Object)messageId.toLowerCase(Locale.getDefault()));
            List rs = select.getResultList();
            if (rs == null || rs.size() == 0) {
                return Collections.emptySet();
            }
            retVal = new HashSet<String>(rs);
        }
        catch (Exception e) {
            throw new NotificationDAOException("Failed to execute received notification DAO query.", e);
        }
        return retVal;
    }

    @Override
    @Transactional(readOnly=false)
    public void purgeNotifications(Calendar purgeTime) throws NotificationDAOException {
        this.validateState();
        try {
            Query delete = this.entityManager.createQuery("DELETE FROM ReceivedNotification rn where rn.receivedTime < ?1");
            delete.setParameter(1, (Object)purgeTime);
            delete.executeUpdate();
            this.entityManager.flush();
        }
        catch (Exception rt) {
            throw new NotificationDAOException("Failed to execute delete.", rt);
        }
    }
}

