/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.dao.impl;

import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.nhindirect.monitor.dao.AggregationDAO;
import org.nhindirect.monitor.dao.AggregationDAOException;
import org.nhindirect.monitor.dao.AggregationVersionException;
import org.nhindirect.monitor.dao.entity.Aggregation;
import org.nhindirect.monitor.dao.entity.AggregationCompleted;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class AggregationDAOImpl
implements AggregationDAO {
    protected static final int DEFAULT_RECOVERY_LOCK_INTERVAL = 120;
    @PersistenceContext(unitName="direct-msg-monitor-store")
    protected EntityManager entityManager;
    protected int recoveredEntityLockInterval = 120;

    protected void validateState() {
        if (this.entityManager == null) {
            throw new IllegalStateException("entityManger has not been initialized");
        }
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setRecoveryLockInterval(int recoveredEntityLockInterval) {
        this.recoveredEntityLockInterval = recoveredEntityLockInterval;
    }

    @Override
    @Transactional(readOnly=true)
    public Aggregation getAggregation(String id) throws AggregationDAOException {
        this.validateState();
        try {
            return (Aggregation)this.entityManager.find(Aggregation.class, (Object)id);
        }
        catch (Exception e) {
            throw new AggregationDAOException(e);
        }
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={AggregationDAOException.class})
    public AggregationCompleted getAggregationCompleted(String id, boolean lock) throws AggregationDAOException {
        this.validateState();
        try {
            if (!lock) {
                return (AggregationCompleted)this.entityManager.find(AggregationCompleted.class, (Object)id);
            }
            AggregationCompleted entity = (AggregationCompleted)this.entityManager.find(AggregationCompleted.class, (Object)id);
            if (entity == null) {
                return null;
            }
            if (entity.getRecoveryLockedUntilDtTm() != null && entity.getRecoveryLockedUntilDtTm().after(Calendar.getInstance(Locale.getDefault()))) {
                return null;
            }
            this.entityManager.lock((Object)entity, LockModeType.WRITE);
            Calendar newRecoveryLockTime = Calendar.getInstance(Locale.getDefault());
            newRecoveryLockTime.add(13, this.recoveredEntityLockInterval);
            entity.setRecoveryLockedUntilDtTm(newRecoveryLockTime);
            this.entityManager.persist((Object)entity);
            this.entityManager.flush();
            return entity;
        }
        catch (OptimisticLockException ol) {
            return null;
        }
        catch (Exception e) {
            throw new AggregationDAOException(e);
        }
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={AggregationDAOException.class})
    public void addUpdateAggregation(Aggregation aggr) throws AggregationDAOException {
        try {
            Aggregation existingAggr = this.getAggregation(aggr.getId());
            if (existingAggr == null && aggr.getVersion() > 0) {
                throw new AggregationVersionException("Aggregation not found but expected to exist due to non 0 version number");
            }
            if (existingAggr != null) {
                if (existingAggr.getVersion() != aggr.getVersion()) {
                    throw new AggregationVersionException("Version number of aggreation does not match what is in the store.");
                }
                this.entityManager.lock((Object)existingAggr, LockModeType.WRITE);
                existingAggr.setExchangeBlob(aggr.getExchangeBlob());
                this.entityManager.persist((Object)existingAggr);
            } else {
                aggr.setVersion(aggr.getVersion() + 1);
                this.entityManager.persist((Object)aggr);
            }
            this.entityManager.flush();
        }
        catch (AggregationDAOException ae) {
            throw ae;
        }
        catch (OptimisticLockException ol) {
            throw new AggregationVersionException("Aggregation was updated by another thread or process before it could be committed.");
        }
        catch (Exception e) {
            throw new AggregationDAOException("Failed to add or update aggregation.", e);
        }
    }

    @Override
    @Transactional(readOnly=false, rollbackFor={AggregationDAOException.class})
    public void removeAggregation(Aggregation agg, String exchangeId) throws AggregationDAOException {
        try {
            Aggregation existingAgg = this.getAggregation(agg.getId());
            if (existingAgg != null) {
                if (existingAgg.getVersion() != agg.getVersion()) {
                    throw new AggregationVersionException("Version number of aggreation does not match what is in the store.");
                }
            } else {
                throw new AggregationDAOException("Aggregation does not exist is store.");
            }
            this.entityManager.lock((Object)existingAgg, LockModeType.WRITE);
            this.entityManager.remove((Object)existingAgg);
            AggregationCompleted completed = new AggregationCompleted();
            completed.setExchangeBlob(existingAgg.getExchangeBlob());
            completed.setId(exchangeId);
            completed.setVersion(1);
            this.entityManager.persist((Object)completed);
            this.entityManager.flush();
        }
        catch (AggregationDAOException ae) {
            throw ae;
        }
        catch (OptimisticLockException ol) {
            throw new AggregationVersionException("Aggregation was removed by another thread or process before it could be committed.");
        }
        catch (Exception e) {
            throw new AggregationDAOException("Failed to remove aggregation.", e);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void confirmAggregation(String id) throws AggregationDAOException {
        try {
            AggregationCompleted completed = (AggregationCompleted)this.entityManager.find(AggregationCompleted.class, (Object)id);
            if (completed != null) {
                this.entityManager.remove((Object)completed);
                this.entityManager.flush();
            }
        }
        catch (Exception e) {
            throw new AggregationDAOException("Failed to confirm aggregation.", e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<String> getAggregationKeys() throws AggregationDAOException {
        String query = "SELECT id from Aggregation agg";
        LinkedList<String> retVal = null;
        try {
            Query select = this.entityManager.createQuery("SELECT id from Aggregation agg");
            List rs = select.getResultList();
            if (rs == null || rs.size() == 0) {
                return Collections.emptyList();
            }
            retVal = new LinkedList<String>(rs);
        }
        catch (Exception e) {
            throw new AggregationDAOException("Failed to get aggregation keys", e);
        }
        return retVal;
    }

    @Override
    @Transactional(readOnly=true)
    public List<String> getAggregationCompletedKeys() throws AggregationDAOException {
        String query = "SELECT id from AggregationCompleted agg";
        LinkedList<String> retVal = null;
        try {
            Query select = this.entityManager.createQuery("SELECT id from AggregationCompleted agg");
            List rs = select.getResultList();
            if (rs == null || rs.size() == 0) {
                return Collections.emptyList();
            }
            retVal = new LinkedList<String>(rs);
        }
        catch (Exception e) {
            throw new AggregationDAOException("Failed to get aggregation completed keys", e);
        }
        return retVal;
    }

    @Override
    @Transactional(readOnly=false)
    public void purgeAll() throws AggregationDAOException {
        try {
            Query delete = this.entityManager.createQuery("DELETE FROM Aggregation agg where agg.version > -1");
            delete.executeUpdate();
            delete = this.entityManager.createQuery("DELETE FROM AggregationCompleted agg where agg.version > -1");
            delete.executeUpdate();
            this.entityManager.flush();
        }
        catch (Exception e) {
            throw new AggregationDAOException("Failed to purge all aggregation information.", e);
        }
    }
}

