/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.condition.impl;

import java.util.Collection;
import java.util.Collections;
import org.nhindirect.common.tx.TxUtil;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.monitor.condition.TxCompletionCondition;
import org.nhindirect.monitor.condition.impl.AbstractCompletionCondition;

public class VariableCompletionCondition
extends AbstractCompletionCondition {
    protected final TxCompletionCondition timelyRelCondition;
    protected final TxCompletionCondition generalCondition;

    public VariableCompletionCondition(TxCompletionCondition timelyRelCondition, TxCompletionCondition generalCondition) {
        if (timelyRelCondition == null || generalCondition == null) {
            throw new IllegalArgumentException("Conditions cannot be null.");
        }
        this.timelyRelCondition = timelyRelCondition;
        this.generalCondition = generalCondition;
    }

    @Override
    public boolean isComplete(Collection<Tx> txs) {
        Tx msgToTrack = this.getMessageToTrackInternal(txs);
        if (msgToTrack == null) {
            return false;
        }
        return this.isRelAndTimelyRequired(msgToTrack) ? this.timelyRelCondition.isComplete(txs) : this.generalCondition.isComplete(txs);
    }

    @Override
    public Collection<String> getIncompleteRecipients(Collection<Tx> txs) {
        Tx msgToTrack = this.getMessageToTrackInternal(txs);
        if (msgToTrack == null) {
            return Collections.emptyList();
        }
        return this.isRelAndTimelyRequired(msgToTrack) ? this.timelyRelCondition.getIncompleteRecipients(txs) : this.generalCondition.getIncompleteRecipients(txs);
    }

    protected boolean isRelAndTimelyRequired(Tx imfMessage) {
        return TxUtil.isReliableAndTimelyRequested((Tx)imfMessage);
    }
}

