/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.condition.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.common.mail.dsn.DSNStandard;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.monitor.condition.impl.AbstractCompletionCondition;
import org.nhindirect.monitor.dao.NotificationDAOException;
import org.nhindirect.monitor.dao.NotificationDuplicationDAO;

public class TimelyAndReliableCompletionCondition
extends AbstractCompletionCondition {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(TimelyAndReliableCompletionCondition.class);
    protected NotificationDuplicationDAO dao;

    public void setDupDAO(NotificationDuplicationDAO dao) {
        this.dao = dao;
    }

    @Override
    public Collection<String> getIncompleteRecipients(Collection<Tx> txs) {
        if (txs == null || txs.size() == 0) {
            return Collections.emptyList();
        }
        Tx originalMessage = this.getMessageToTrackInternal(txs);
        if (originalMessage == null) {
            return Collections.emptyList();
        }
        TxDetail originalRecipDetail = originalMessage.getDetail(TxDetailType.RECIPIENTS.getType());
        if (originalRecipDetail == null) {
            return Collections.emptyList();
        }
        HashMap<String, RecipientResponseStatus> recipStatuses = new HashMap<String, RecipientResponseStatus>();
        for (String recip : originalRecipDetail.getDetailValue().split(",")) {
            recipStatuses.put(recip.trim(), new RecipientResponseStatus(recip.trim()));
        }
        block5: for (Tx tx : txs) {
            TxDetail finalRecipDetail = tx.getDetail(TxDetailType.FINAL_RECIPIENTS);
            if (finalRecipDetail == null) continue;
            switch (tx.getMsgType()) {
                case MDN: {
                    RecipientResponseStatus recipStatus = (RecipientResponseStatus)recipStatuses.get(TimelyAndReliableCompletionCondition.normalizeFinalRecip(finalRecipDetail.getDetailValue().trim()));
                    TxDetail dispDetail = tx.getDetail(TxDetailType.DISPOSITION);
                    if (dispDetail == null || recipStatus == null) break;
                    String dispValue = dispDetail.getDetailValue();
                    if (dispValue.contains("processed")) {
                        recipStatus.addReceivedStatus((short)1);
                        break;
                    }
                    if (dispValue.contains("dispatched")) {
                        TxDetail mdnOptionDetail = tx.getDetail(TxDetailType.DISPOSITION_OPTIONS);
                        if (mdnOptionDetail == null || !mdnOptionDetail.getDetailValue().contains("X-DIRECT-FINAL-DESTINATION-DELIVERY")) continue block5;
                        recipStatus.addReceivedStatus((short)2);
                        break;
                    }
                    if (!dispValue.contains("denied") && !dispValue.contains("error")) continue block5;
                    recipStatus.addReceivedStatus((short)4);
                    break;
                }
                case DSN: {
                    String actionValue;
                    TxDetail actionDetail = tx.getDetail(TxDetailType.DSN_ACTION);
                    if (actionDetail == null || !(actionValue = actionDetail.getDetailValue()).contains(DSNStandard.DSNAction.FAILED.toString())) break;
                    for (String finalRecip : finalRecipDetail.getDetailValue().split(",")) {
                        RecipientResponseStatus recipStatus = (RecipientResponseStatus)recipStatuses.get(TimelyAndReliableCompletionCondition.normalizeFinalRecip(finalRecip.trim()));
                        if (recipStatus == null) continue;
                        recipStatus.addReceivedStatus((short)8);
                    }
                    break;
                }
            }
        }
        ArrayList<String> retVal = new ArrayList<String>();
        for (RecipientResponseStatus status : recipStatuses.values()) {
            if (!(status.isMDNDispatchedReceived() && status.isMDNProcessedReceived() || status.isMDNFailedReceived() || status.isDSNFailedReceived())) {
                retVal.add(status.getRecipient());
                continue;
            }
            TxDetail detail = originalMessage.getDetail(TxDetailType.MSG_ID);
            if (detail == null) continue;
            this.addMessageToDuplicateStore(detail.getDetailValue(), status.getRecipient());
        }
        return retVal;
    }

    protected void addMessageToDuplicateStore(String messageId, String address) {
        if (this.dao != null) {
            try {
                this.dao.addNotification(messageId, address);
            }
            catch (NotificationDAOException e) {
                LOGGER.warn((Object)"Could not add transaction to duplication state manager.", (Throwable)e);
            }
        }
    }

    private static class RecipientResponseStatus {
        public static final short MDNProcessReceived = 1;
        public static final short MDNDispatchedReceived = 2;
        public static final short MDNFailedReceived = 4;
        public static final short DSNFailedReceived = 8;
        protected int statusesReceived = 0;
        protected final String recipient;

        RecipientResponseStatus(String recipient) {
            this.recipient = recipient;
        }

        public void addReceivedStatus(short status) {
            this.statusesReceived |= status;
        }

        public boolean isMDNProcessedReceived() {
            return (this.statusesReceived & 1) > 0;
        }

        public boolean isMDNDispatchedReceived() {
            return (this.statusesReceived & 2) > 0;
        }

        public boolean isMDNFailedReceived() {
            return (this.statusesReceived & 4) > 0;
        }

        public boolean isDSNFailedReceived() {
            return (this.statusesReceived & 8) > 0;
        }

        public String getRecipient() {
            return this.recipient;
        }
    }
}

