/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.condition.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.monitor.condition.impl.AbstractCompletionCondition;

public class GeneralCompletionCondition
extends AbstractCompletionCondition {
    @Override
    public Collection<String> getIncompleteRecipients(Collection<Tx> txs) {
        if (txs == null || txs.size() == 0) {
            return Collections.emptyList();
        }
        Tx originalMessage = GeneralCompletionCondition.getMessageToTrack(txs);
        if (originalMessage == null) {
            return Collections.emptyList();
        }
        TxDetail originalRecipDetail = originalMessage.getDetail(TxDetailType.RECIPIENTS.getType());
        if (originalRecipDetail == null) {
            return Collections.emptyList();
        }
        HashMap<String, RecipientResponseStatus> recipStatuses = new HashMap<String, RecipientResponseStatus>();
        for (String recip : originalRecipDetail.getDetailValue().split(",")) {
            recipStatuses.put(recip.trim(), new RecipientResponseStatus(recip.trim()));
        }
        for (Tx tx : txs) {
            TxDetail finalRecipDetail = tx.getDetail(TxDetailType.FINAL_RECIPIENTS.getType());
            if (finalRecipDetail == null) continue;
            switch (tx.getMsgType()) {
                case MDN: {
                    RecipientResponseStatus recipStatus = (RecipientResponseStatus)recipStatuses.get(GeneralCompletionCondition.normalizeFinalRecip(finalRecipDetail.getDetailValue().trim()));
                    if (recipStatus == null) break;
                    recipStatus.addReceivedStatus((short)1);
                    break;
                }
                case DSN: {
                    for (String finalRecip : finalRecipDetail.getDetailValue().split(",")) {
                        RecipientResponseStatus recipStatus = (RecipientResponseStatus)recipStatuses.get(GeneralCompletionCondition.normalizeFinalRecip(finalRecip.trim()));
                        if (recipStatus == null) continue;
                        recipStatus.addReceivedStatus((short)2);
                    }
                    break;
                }
            }
        }
        ArrayList<String> retVal = new ArrayList<String>();
        for (RecipientResponseStatus status : recipStatuses.values()) {
            if (status.getReceivedStatus() != 0) continue;
            retVal.add(status.getRecipient());
        }
        return retVal;
    }

    private static class RecipientResponseStatus {
        public static final short MDNReceived = 1;
        public static final short DSNReceived = 2;
        protected int statusesReceived = 0;
        protected final String recipient;

        RecipientResponseStatus(String recipient) {
            this.recipient = recipient;
        }

        public void addReceivedStatus(short status) {
            this.statusesReceived |= status;
        }

        public int getReceivedStatus() {
            return this.statusesReceived;
        }

        public String getRecipient() {
            return this.recipient;
        }
    }
}

