/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.condition.impl;

import java.util.Collection;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.condition.TxCompletionCondition;

public abstract class AbstractCompletionCondition
implements TxCompletionCondition {
    public static Tx getMessageToTrack(Collection<Tx> txs) {
        if (txs == null || txs.size() == 0) {
            return null;
        }
        for (Tx tx : txs) {
            if (tx.getMsgType() != TxMessageType.IMF) continue;
            return tx;
        }
        return null;
    }

    protected Tx getMessageToTrackInternal(Collection<Tx> txs) {
        return AbstractCompletionCondition.getMessageToTrack(txs);
    }

    @Override
    public boolean isComplete(Collection<Tx> txs) {
        if (txs == null || txs.size() == 0) {
            return false;
        }
        Tx originalMessage = this.getMessageToTrackInternal(txs);
        if (originalMessage == null) {
            return false;
        }
        TxDetail originalRecipDetail = originalMessage.getDetail(TxDetailType.RECIPIENTS.getType());
        if (originalRecipDetail == null) {
            return false;
        }
        Collection<String> incompleteRecips = this.getIncompleteRecipients(txs);
        return incompleteRecips.isEmpty();
    }

    public static String normalizeFinalRecip(String recip) {
        String normalizedString = recip;
        int index = recip.indexOf(";");
        if (index > -1) {
            normalizedString = recip.substring(index + 1).trim();
        }
        return normalizedString;
    }
}

