/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.aggregator.repository;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.hawtdb.HawtDBCamelCodec;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.support.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.hawtbuf.Buffer;
import org.nhindirect.monitor.dao.AggregationDAO;
import org.nhindirect.monitor.dao.entity.Aggregation;
import org.nhindirect.monitor.dao.entity.AggregationCompleted;

public class ConcurrentJPAAggregationRepository
extends ServiceSupport
implements RecoverableAggregationRepository {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(ConcurrentJPAAggregationRepository.class);
    protected static final String AGGREGATION_ENTITY_VERSON = "AGGREGATION_ENTITY_VERSON";
    protected static final String AGGREGATION_COMPLETE_ENTITY_VERSON = "AGGREGATION_COMPLETE_ENTITY_VERSON";
    protected HawtDBCamelCodec codec = new HawtDBCamelCodec();
    protected AggregationDAO dao;
    protected long recoveryInterval = 5000L;
    protected boolean useRecovery = true;
    protected int maximumRedeliveries;
    protected String deadLetterUri;

    public ConcurrentJPAAggregationRepository() {
    }

    public ConcurrentJPAAggregationRepository(AggregationDAO dao) {
        this.dao = dao;
    }

    public void setAggreationDAO(AggregationDAO dao) {
        this.dao = dao;
    }

    public Exchange add(CamelContext camelContext, String key, Exchange exchange) {
        try {
            byte[] blob = this.codec.marshallExchange(camelContext, exchange).getData();
            Integer currentEntityVersion = (Integer)exchange.getProperty(AGGREGATION_ENTITY_VERSON);
            Aggregation agg = new Aggregation();
            agg.setExchangeBlob(blob);
            agg.setId(key);
            agg.setVersion(currentEntityVersion == null ? 0 : currentEntityVersion);
            this.dao.addUpdateAggregation(agg);
            exchange.setProperty(AGGREGATION_ENTITY_VERSON, (Object)agg.getVersion());
        }
        catch (Exception e) {
            throw new RuntimeException("Error adding to repository aggregation with key " + key, e);
        }
        return null;
    }

    public Exchange get(CamelContext camelContext, String key) {
        Exchange retVal = null;
        try {
            Aggregation agg = this.dao.getAggregation(key);
            if (agg == null) {
                return null;
            }
            retVal = this.codec.unmarshallExchange(camelContext, new Buffer(agg.getExchangeBlob()));
            retVal.setProperty(AGGREGATION_ENTITY_VERSON, (Object)agg.getVersion());
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving from repository aggregation with key " + key, e);
        }
        return retVal;
    }

    public void remove(CamelContext camelContext, String key, Exchange exchange) {
        try {
            Integer currentEntityVersion = (Integer)exchange.getProperty(AGGREGATION_ENTITY_VERSON);
            byte[] blob = this.codec.marshallExchange(camelContext, exchange).getData();
            Aggregation agg = new Aggregation();
            agg.setExchangeBlob(blob);
            agg.setId(key);
            agg.setVersion(currentEntityVersion == null ? 0 : currentEntityVersion);
            this.dao.removeAggregation(agg, exchange.getExchangeId());
        }
        catch (Exception e) {
            throw new RuntimeException("Error removing from repository aggregation with key " + key, e);
        }
    }

    public void confirm(CamelContext camelContext, String exchangeId) {
        try {
            this.dao.confirmAggregation(exchangeId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error confirming aggregation with key " + exchangeId, e);
        }
    }

    public Set<String> getKeys() {
        try {
            List<String> keys = this.dao.getAggregationKeys();
            if (keys == null || keys.isEmpty()) {
                return Collections.emptySet();
            }
            return new LinkedHashSet<String>(keys);
        }
        catch (Exception e) {
            throw new RuntimeException("Error retriving aggregation keys", e);
        }
    }

    public Set<String> scan(CamelContext camelContext) {
        try {
            List<String> keys = this.dao.getAggregationCompletedKeys();
            if (keys == null || keys.isEmpty()) {
                return Collections.emptySet();
            }
            return new LinkedHashSet<String>(keys);
        }
        catch (Exception e) {
            throw new RuntimeException("Error retriving aggregation completed keys", e);
        }
    }

    public Exchange recover(CamelContext camelContext, String exchangeId) {
        Exchange retVal = null;
        try {
            AggregationCompleted agg = this.dao.getAggregationCompleted(exchangeId, true);
            if (agg == null) {
                return null;
            }
            retVal = this.codec.unmarshallExchange(camelContext, new Buffer(agg.getExchangeBlob()));
            retVal.setProperty(AGGREGATION_COMPLETE_ENTITY_VERSON, (Object)agg.getVersion());
        }
        catch (Exception e) {
            throw new RuntimeException("Error recovering exchange from repository with exchangeId " + exchangeId, e);
        }
        return retVal;
    }

    public void setRecoveryInterval(long interval, TimeUnit timeUnit) {
        this.recoveryInterval = timeUnit.toMillis(interval);
    }

    public void setRecoveryInterval(long interval) {
        this.recoveryInterval = interval;
    }

    public long getRecoveryIntervalInMillis() {
        return this.recoveryInterval;
    }

    public void setUseRecovery(boolean useRecovery) {
        this.useRecovery = useRecovery;
    }

    public boolean isUseRecovery() {
        return this.useRecovery;
    }

    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetterUri = deadLetterUri;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    protected void doStart() throws Exception {
        if (this.dao == null) {
            throw new IllegalStateException("Aggregation respository DAO cannot be null");
        }
        int current = this.getKeys().size();
        int completed = this.scan(null).size();
        if (current > 0) {
            LOGGER.info((Object)("On startup there are " + current + " aggregate exchanges (not completed) in repository"));
        } else {
            LOGGER.info((Object)"On startup there are no existing aggregate exchanges (not completed) in repository");
        }
        if (completed > 0) {
            LOGGER.warn((Object)("On startup there are " + completed + " completed exchanges to be recovered in repository"));
        } else {
            LOGGER.info((Object)"On startup there are no completed exchanges to be recovered in repository");
        }
    }

    protected void doStop() throws Exception {
    }
}

