/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.monitor.condition.TxCompletionCondition;
import org.nhindirect.monitor.condition.TxTimeoutCondition;

public class BasicTxAggregator
implements AggregationStrategy {
    protected final TxCompletionCondition completionCondition;
    protected final TxTimeoutCondition timeoutCondition;

    public BasicTxAggregator(TxCompletionCondition completionCondition, TxTimeoutCondition timeoutCondition) {
        this.completionCondition = completionCondition;
        this.timeoutCondition = timeoutCondition;
    }

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange == null) {
            ArrayList<Object> txs = new ArrayList<Object>();
            txs.add(newExchange.getIn().getBody(Tx.class));
            newExchange.getIn().setBody(txs);
            return newExchange;
        }
        Collection txs = (Collection)oldExchange.getIn().getBody(Collection.class);
        txs.add(newExchange.getIn().getBody(Tx.class));
        oldExchange.getIn().setBody((Object)txs);
        return oldExchange;
    }

    public boolean isAggregationComplete(Exchange theExchange) {
        if (this.completionCondition == null) {
            throw new IllegalStateException("Completion condition cannot be null when utilizing the isAggregationComplete method");
        }
        Collection txs = (Collection)theExchange.getIn().getBody(Collection.class);
        if (txs == null) {
            return false;
        }
        return this.completionCondition.isComplete(txs);
    }

    public Long getAggregationTime(Exchange theExchange) {
        if (this.timeoutCondition == null) {
            throw new IllegalStateException("Timeout condition cannot be null when utilizing the getAggregationTime method");
        }
        Collection txs = (Collection)theExchange.getIn().getBody(Collection.class);
        if (txs == null) {
            return null;
        }
        Date initialExhangeTime = (Date)theExchange.getProperty("CamelCreatedTimestamp", Date.class);
        if (initialExhangeTime == null) {
            return null;
        }
        return this.timeoutCondition.getTimeout(txs, initialExhangeTime.getTime());
    }
}

