/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EntityNameUse implements Enumerator
{
    A(0, "A", "A"),
    ABC(1, "ABC", "ABC"),
    ASGN(2, "ASGN", "ASGN"),
    C(3, "C", "C"),
    I(4, "I", "I"),
    IDE(5, "IDE", "IDE"),
    L(6, "L", "L"),
    P(7, "P", "P"),
    PHON(8, "PHON", "PHON"),
    R(9, "R", "R"),
    SNDX(10, "SNDX", "SNDX"),
    SRCH(11, "SRCH", "SRCH"),
    SYL(12, "SYL", "SYL");

    public static final int A_VALUE = 0;
    public static final int ABC_VALUE = 1;
    public static final int ASGN_VALUE = 2;
    public static final int C_VALUE = 3;
    public static final int I_VALUE = 4;
    public static final int IDE_VALUE = 5;
    public static final int L_VALUE = 6;
    public static final int P_VALUE = 7;
    public static final int PHON_VALUE = 8;
    public static final int R_VALUE = 9;
    public static final int SNDX_VALUE = 10;
    public static final int SRCH_VALUE = 11;
    public static final int SYL_VALUE = 12;
    private static final EntityNameUse[] VALUES_ARRAY;
    public static final List<EntityNameUse> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EntityNameUse[]{A, ABC, ASGN, C, I, IDE, L, P, PHON, R, SNDX, SRCH, SYL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EntityNameUse get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EntityNameUse result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EntityNameUse getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EntityNameUse result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EntityNameUse get(int value) {
        switch (value) {
            case 0: {
                return A;
            }
            case 1: {
                return ABC;
            }
            case 2: {
                return ASGN;
            }
            case 3: {
                return C;
            }
            case 4: {
                return I;
            }
            case 5: {
                return IDE;
            }
            case 6: {
                return L;
            }
            case 7: {
                return P;
            }
            case 8: {
                return PHON;
            }
            case 9: {
                return R;
            }
            case 10: {
                return SNDX;
            }
            case 11: {
                return SRCH;
            }
            case 12: {
                return SYL;
            }
        }
        return null;
    }

    private EntityNameUse(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

