/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EntityNamePartType implements Enumerator
{
    DEL(0, "DEL", "DEL"),
    FAM(1, "FAM", "FAM"),
    GIV(2, "GIV", "GIV"),
    PFX(3, "PFX", "PFX"),
    SFX(4, "SFX", "SFX");

    public static final int DEL_VALUE = 0;
    public static final int FAM_VALUE = 1;
    public static final int GIV_VALUE = 2;
    public static final int PFX_VALUE = 3;
    public static final int SFX_VALUE = 4;
    private static final EntityNamePartType[] VALUES_ARRAY;
    public static final List<EntityNamePartType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EntityNamePartType[]{DEL, FAM, GIV, PFX, SFX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EntityNamePartType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EntityNamePartType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EntityNamePartType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EntityNamePartType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EntityNamePartType get(int value) {
        switch (value) {
            case 0: {
                return DEL;
            }
            case 1: {
                return FAM;
            }
            case 2: {
                return GIV;
            }
            case 3: {
                return PFX;
            }
            case 4: {
                return SFX;
            }
        }
        return null;
    }

    private EntityNamePartType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

