/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EntityClassPlace implements Enumerator
{
    CITY(0, "CITY", "CITY"),
    COUNTRY(1, "COUNTRY", "COUNTRY"),
    COUNTY(2, "COUNTY", "COUNTY"),
    PLC(3, "PLC", "PLC"),
    PROVINCE(4, "PROVINCE", "PROVINCE");

    public static final int CITY_VALUE = 0;
    public static final int COUNTRY_VALUE = 1;
    public static final int COUNTY_VALUE = 2;
    public static final int PLC_VALUE = 3;
    public static final int PROVINCE_VALUE = 4;
    private static final EntityClassPlace[] VALUES_ARRAY;
    public static final List<EntityClassPlace> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EntityClassPlace[]{CITY, COUNTRY, COUNTY, PLC, PROVINCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EntityClassPlace get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EntityClassPlace result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EntityClassPlace getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EntityClassPlace result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EntityClassPlace get(int value) {
        switch (value) {
            case 0: {
                return CITY;
            }
            case 1: {
                return COUNTRY;
            }
            case 2: {
                return COUNTY;
            }
            case 3: {
                return PLC;
            }
            case 4: {
                return PROVINCE;
            }
        }
        return null;
    }

    private EntityClassPlace(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

