/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EntityClassOrganization implements Enumerator
{
    NAT(0, "NAT", "NAT"),
    ORG(1, "ORG", "ORG"),
    PUB(2, "PUB", "PUB"),
    STATE(3, "STATE", "STATE");

    public static final int NAT_VALUE = 0;
    public static final int ORG_VALUE = 1;
    public static final int PUB_VALUE = 2;
    public static final int STATE_VALUE = 3;
    private static final EntityClassOrganization[] VALUES_ARRAY;
    public static final List<EntityClassOrganization> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EntityClassOrganization[]{NAT, ORG, PUB, STATE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EntityClassOrganization get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EntityClassOrganization result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EntityClassOrganization getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EntityClassOrganization result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EntityClassOrganization get(int value) {
        switch (value) {
            case 0: {
                return NAT;
            }
            case 1: {
                return ORG;
            }
            case 2: {
                return PUB;
            }
            case 3: {
                return STATE;
            }
        }
        return null;
    }

    private EntityClassOrganization(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

