/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CompressionAlgorithm implements Enumerator
{
    DF(0, "DF", "DF"),
    GZ(1, "GZ", "GZ"),
    Z(2, "Z", "Z"),
    ZL(3, "ZL", "ZL");

    public static final int DF_VALUE = 0;
    public static final int GZ_VALUE = 1;
    public static final int Z_VALUE = 2;
    public static final int ZL_VALUE = 3;
    private static final CompressionAlgorithm[] VALUES_ARRAY;
    public static final List<CompressionAlgorithm> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CompressionAlgorithm[]{DF, GZ, Z, ZL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CompressionAlgorithm get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompressionAlgorithm result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompressionAlgorithm getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompressionAlgorithm result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompressionAlgorithm get(int value) {
        switch (value) {
            case 0: {
                return DF;
            }
            case 1: {
                return GZ;
            }
            case 2: {
                return Z;
            }
            case 3: {
                return ZL;
            }
        }
        return null;
    }

    private CompressionAlgorithm(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

