/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.configkit;

import java.io.InputStream;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFactory;
import org.realityforge.configkit.ConfigValidator;
import org.realityforge.configkit.ResolverFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class ConfigValidatorFactory {
    public static final String RELAX_NG = "http://relaxng.org/ns/structure/1.0";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static Class c_msvClass;

    public static ConfigValidator create(String publicID, String systemID, ClassLoader classLoader) throws Exception {
        return ConfigValidatorFactory.create(null, publicID, systemID, classLoader);
    }

    public static ConfigValidator create(String schemaType, String publicID, String systemID, ClassLoader classLoader) throws Exception {
        if (null == publicID && null == systemID) {
            throw new NullPointerException("publicID");
        }
        EntityResolver resolver = ResolverFactory.createResolver(classLoader);
        InputSource inputSource = resolver.resolveEntity(publicID, systemID);
        if (null == inputSource) {
            String message = "Unable to locate schema with id " + publicID + "/" + systemID;
            throw new Exception(message);
        }
        return ConfigValidatorFactory.create(schemaType, inputSource, resolver);
    }

    public static ConfigValidator create(InputStream inputStream) throws Exception {
        return ConfigValidatorFactory.create(null, inputStream);
    }

    public static ConfigValidator create(String schemaType, InputStream inputStream) throws Exception {
        if (null == inputStream) {
            throw new NullPointerException("inputStream");
        }
        InputSource inputSource = new InputSource(inputStream);
        return ConfigValidatorFactory.create(schemaType, inputSource);
    }

    public static ConfigValidator create(String schemaType, InputStream inputStream, EntityResolver resolver) throws Exception {
        if (null == inputStream) {
            throw new NullPointerException("inputStream");
        }
        InputSource inputSource = new InputSource(inputStream);
        return ConfigValidatorFactory.create(schemaType, inputSource, resolver);
    }

    public static ConfigValidator create(InputSource inputSource) throws Exception {
        return ConfigValidatorFactory.create(null, inputSource, null);
    }

    public static ConfigValidator create(InputSource inputSource, EntityResolver resolver) throws Exception {
        return ConfigValidatorFactory.create(null, inputSource, resolver);
    }

    public static ConfigValidator create(String schemaType, InputSource inputSource) throws Exception {
        return ConfigValidatorFactory.create(schemaType, inputSource, null);
    }

    public static ConfigValidator create(String schemaType, InputSource inputSource, EntityResolver entityResolver) throws Exception {
        if (null == inputSource) {
            throw new NullPointerException("inputSource");
        }
        VerifierFactory factory = ConfigValidatorFactory.createFactory(schemaType);
        Schema schema = factory.compileSchema(inputSource);
        return new ConfigValidator(schema, entityResolver);
    }

    private static VerifierFactory createFactory(String schemaType) throws VerifierConfigurationException {
        if (null == schemaType) {
            try {
                if (null == c_msvClass) {
                    c_msvClass = Class.forName("com.sun.msv.verifier.jarv.TheFactoryImpl");
                }
                return (VerifierFactory)c_msvClass.newInstance();
            }
            catch (Exception e) {
                String message = "Unable to load MSV factory and thus can not auto-discover schema type.";
                throw new VerifierConfigurationException("Unable to load MSV factory and thus can not auto-discover schema type.", e);
            }
        }
        return VerifierFactory.newInstance((String)schemaType);
    }

    static {
        RELAX_NG = RELAX_NG;
        W3C_XML_SCHEMA = W3C_XML_SCHEMA;
    }
}

