/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp.config;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.nhindirect.gateway.smtp.DomainPostmaster;
import org.nhindirect.gateway.smtp.NotificationProducer;
import org.nhindirect.gateway.smtp.NotificationSettings;
import org.nhindirect.gateway.smtp.ProcessBadMessageSettings;
import org.nhindirect.gateway.smtp.ProcessIncomingSettings;
import org.nhindirect.gateway.smtp.ProcessOutgoingSettings;
import org.nhindirect.gateway.smtp.RawMessageSettings;
import org.nhindirect.gateway.smtp.SmtpAgent;
import org.nhindirect.gateway.smtp.SmtpAgentError;
import org.nhindirect.gateway.smtp.SmtpAgentException;
import org.nhindirect.gateway.smtp.SmtpAgentSettings;
import org.nhindirect.gateway.smtp.config.SmtpAgentConfig;
import org.nhindirect.gateway.smtp.module.SmtpAgentModule;
import org.nhindirect.gateway.smtp.provider.DefaultSmtpAgentProvider;
import org.nhindirect.stagent.NHINDAgent;
import org.nhindirect.stagent.cert.CertStoreCachePolicy;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.DefaultCertStoreCachePolicy;
import org.nhindirect.stagent.cert.impl.EmployLdapAuthInformation;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.cert.impl.LDAPCertificateStore;
import org.nhindirect.stagent.cert.impl.LdapStoreConfiguration;
import org.nhindirect.stagent.cert.impl.provider.DNSCertStoreProvider;
import org.nhindirect.stagent.cert.impl.provider.KeyStoreCertificateStoreProvider;
import org.nhindirect.stagent.cert.impl.provider.LdapCertificateStoreProvider;
import org.nhindirect.stagent.module.AgentModule;
import org.nhindirect.stagent.module.PrivateCertStoreModule;
import org.nhindirect.stagent.module.PublicCertStoreModule;
import org.nhindirect.stagent.module.TrustAnchorModule;
import org.nhindirect.stagent.trust.provider.MultiDomainTrustAnchorResolverProvider;
import org.nhindirect.stagent.trust.provider.UniformTrustAnchorResolverProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLSmtpAgentConfig
implements SmtpAgentConfig {
    @Inject(optional=true)
    private Provider<SmtpAgent> smtpAgentProvider;
    @Inject
    private Provider<NHINDAgent> agentProvider;
    protected LDAPCertificateStore ldapCertificateStore;
    private Document doc;
    protected Collection<String> domains;
    protected Map<String, DomainPostmaster> domainPostmasters;
    protected Module publicCertModule;
    protected Module privateCertModule;
    protected Module certAnchorModule;
    private RawMessageSettings rawSettings;
    private ProcessIncomingSettings incomingSettings;
    private ProcessOutgoingSettings outgoingSettings;
    private ProcessBadMessageSettings badSettings;
    private NotificationProducer notificationProducer;
    private Collection<Provider<CertificateResolver>> resolverProviders = new ArrayList<Provider<CertificateResolver>>();

    public XMLSmtpAgentConfig(String configFile, Provider<NHINDAgent> agentProvider) {
        this.agentProvider = agentProvider;
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.doc = db.parse(new File(configFile));
        }
        catch (Exception e) {
            throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat, e);
        }
    }

    @Override
    public Injector getAgentInjector() {
        return this.buildAgentInjector();
    }

    private Injector buildAgentInjector() {
        Node docNode = this.doc.getFirstChild().getFirstChild();
        do {
            if (docNode.getNodeName().equalsIgnoreCase("domains")) {
                this.buildDomains(docNode);
                continue;
            }
            if (docNode.getNodeName().equalsIgnoreCase("publiccertstore")) {
                this.buildPublicCertStore(docNode);
                this.publicCertModule = new PublicCertStoreModule(this.resolverProviders);
                continue;
            }
            if (docNode.getNodeName().equalsIgnoreCase("publiccertstores")) {
                this.buildPublicCertStores(docNode);
                this.publicCertModule = new PublicCertStoreModule(this.resolverProviders);
                continue;
            }
            if (docNode.getNodeName().equalsIgnoreCase("privatecertstore")) {
                this.buildPrivateCertStore(docNode);
                continue;
            }
            if (docNode.getNodeName().equalsIgnoreCase("rawmessagesettings")) {
                this.buildRawMessageSettings(docNode);
                continue;
            }
            if (docNode.getNodeName().equalsIgnoreCase("incomingmessagessettings")) {
                this.buildIncomingMessageSettings(docNode);
                continue;
            }
            if (docNode.getNodeName().equalsIgnoreCase("outgoingmessagessettings")) {
                this.buildOutgoingMessageSettings(docNode);
                continue;
            }
            if (docNode.getNodeName().equalsIgnoreCase("badmessagessettings")) {
                this.buildBadMessageSettings(docNode);
                continue;
            }
            if (!docNode.getNodeName().equalsIgnoreCase("mdnsettings")) continue;
            this.buildMDNSettings(docNode);
        } while ((docNode = docNode.getNextSibling()) != null);
        if (this.domains == null) {
            throw new SmtpAgentException(SmtpAgentError.MissingDomains);
        }
        SmtpAgentSettings settings = new SmtpAgentSettings(this.domainPostmasters, this.rawSettings, this.outgoingSettings, this.incomingSettings, this.badSettings, this.notificationProducer);
        if (this.smtpAgentProvider == null) {
            this.smtpAgentProvider = new DefaultSmtpAgentProvider(settings);
        }
        AgentModule agentModule = this.agentProvider == null ? AgentModule.create(this.domains, (Module)this.publicCertModule, (Module)this.privateCertModule, (Module)this.certAnchorModule) : AgentModule.create(this.agentProvider);
        return Guice.createInjector((Module[])new Module[]{agentModule, SmtpAgentModule.create(this.smtpAgentProvider)});
    }

    private void buildMDNSettings(Node MDNNode) {
        if (MDNNode.getNodeType() == 1) {
            Element settingsNode = (Element)MDNNode;
            String autoResponseString = settingsNode.getAttribute("autoResponse");
            boolean autoResponse = autoResponseString == null || autoResponseString.isEmpty() ? true : Boolean.parseBoolean(autoResponseString);
            String prodName = settingsNode.getAttribute("productName");
            String text = null;
            Node childNode = MDNNode.getFirstChild();
            do {
                if (childNode.getNodeType() != 1 || !childNode.getNodeName().equalsIgnoreCase("text")) continue;
                text = childNode.getFirstChild().getNodeValue();
            } while ((childNode = childNode.getNextSibling()) != null);
            this.notificationProducer = new NotificationProducer(new NotificationSettings(autoResponse, prodName, text));
        }
    }

    private void buildDomains(Node domainsNode) {
        this.domains = new ArrayList<String>();
        this.domainPostmasters = new HashMap<String, DomainPostmaster>();
        Node domainNode = domainsNode.getFirstChild();
        Node anchorStoreNode = null;
        HashMap<String, Collection<String>> incomingAnchorHolder = new HashMap<String, Collection<String>>();
        HashMap<String, Collection<String>> outgoingAnchorHolder = new HashMap<String, Collection<String>>();
        do {
            String domain = "";
            String postmasterAddr = "";
            if (domainNode.getNodeType() != 1) continue;
            if (domainNode.getNodeName().equalsIgnoreCase("domain")) {
                Element domainEl = (Element)domainNode;
                domain = domainEl.getAttribute("name");
                if (domain == null || domain.trim().length() == 0) {
                    throw new SmtpAgentException(SmtpAgentError.MissingDomainName);
                }
                postmasterAddr = domainEl.getAttribute("postmaster");
                if (postmasterAddr == null || postmasterAddr.trim().length() == 0) {
                    postmasterAddr = DomainPostmaster.getDefaultPostmaster(domain);
                }
                this.domains.add(domain);
                try {
                    this.domainPostmasters.put(domain.toUpperCase(Locale.getDefault()), new DomainPostmaster(domain, new InternetAddress(postmasterAddr)));
                }
                catch (AddressException e) {
                    // empty catch block
                }
                Node anchorsNode = domainNode.getFirstChild();
                do {
                    if (anchorsNode.getNodeType() != 1) continue;
                    if (anchorsNode.getNodeName().equalsIgnoreCase("incomingtrustanchors")) {
                        incomingAnchorHolder.put(domain, this.getConfiguredTrustAnchorNames(anchorsNode));
                        continue;
                    }
                    if (!anchorsNode.getNodeName().equalsIgnoreCase("outgoingtrustanchors")) continue;
                    outgoingAnchorHolder.put(domain, this.getConfiguredTrustAnchorNames(anchorsNode));
                } while ((anchorsNode = anchorsNode.getNextSibling()) != null);
                continue;
            }
            if (!domainNode.getNodeName().equalsIgnoreCase("anchorstore")) continue;
            anchorStoreNode = domainNode;
        } while ((domainNode = domainNode.getNextSibling()) != null);
        if (this.domains.size() == 0) {
            throw new SmtpAgentException(SmtpAgentError.MissingDomains);
        }
        this.buildTrustAnchorResolver((Element)anchorStoreNode, incomingAnchorHolder, outgoingAnchorHolder);
    }

    protected void buildTrustAnchorResolver(Element anchorStoreNode, Map<String, Collection<String>> incomingAnchorHolder, Map<String, Collection<String>> outgoingAnchorHolder) {
        String type;
        UniformTrustAnchorResolverProvider provider = null;
        String storeType = anchorStoreNode.getAttribute("storeType");
        HashMap incomingAnchors = new HashMap();
        HashMap outgoingAnchors = new HashMap();
        if (storeType.equalsIgnoreCase("keystore")) {
            X509Certificate cert;
            ArrayList<X509Certificate> certs;
            KeyStoreCertificateStore store = new KeyStoreCertificateStore(anchorStoreNode.getAttribute("file"), anchorStoreNode.getAttribute("filePass"), anchorStoreNode.getAttribute("privKeyPass"));
            for (Map.Entry<String, Collection<String>> entries : incomingAnchorHolder.entrySet()) {
                certs = new ArrayList<X509Certificate>();
                for (String alias : entries.getValue()) {
                    cert = store.getByAlias(alias);
                    if (cert == null) continue;
                    certs.add(cert);
                }
                incomingAnchors.put(entries.getKey(), certs);
            }
            for (Map.Entry<String, Collection<String>> entries : outgoingAnchorHolder.entrySet()) {
                certs = new ArrayList();
                for (String alias : entries.getValue()) {
                    cert = store.getByAlias(alias);
                    if (cert == null) continue;
                    certs.add(cert);
                }
                outgoingAnchors.put(entries.getKey(), certs);
            }
        } else if (storeType.equalsIgnoreCase("ldap")) {
            ArrayList certs;
            this.ldapCertificateStore = (LDAPCertificateStore)this.buildLdapCertificateStoreProvider(anchorStoreNode, "LDAPTrustAnchorStore").get();
            for (Map.Entry<String, Collection<String>> entries : incomingAnchorHolder.entrySet()) {
                certs = new ArrayList();
                for (String alias : entries.getValue()) {
                    certs.addAll(this.ldapCertificateStore.getCertificates(alias));
                }
                incomingAnchors.put(entries.getKey(), certs);
            }
            for (Map.Entry<String, Collection<String>> entries : outgoingAnchorHolder.entrySet()) {
                certs = new ArrayList();
                for (String alias : entries.getValue()) {
                    certs.addAll(this.ldapCertificateStore.getCertificates(alias));
                }
                outgoingAnchors.put(entries.getKey(), certs);
            }
        }
        if ((type = anchorStoreNode.getAttribute("type")).equalsIgnoreCase("uniform")) {
            provider = new UniformTrustAnchorResolverProvider((Collection)incomingAnchors.values().iterator().next());
        } else if (type.equalsIgnoreCase("multidomain")) {
            provider = new MultiDomainTrustAnchorResolverProvider(incomingAnchors, outgoingAnchors);
        } else {
            throw new SmtpAgentException(SmtpAgentError.InvalidTrustAnchorSettings);
        }
        this.certAnchorModule = TrustAnchorModule.create((Provider)provider);
    }

    private Collection<String> getConfiguredTrustAnchorNames(Node anchorsNode) {
        List<String> retVal = new ArrayList<String>();
        Node anchorNamesNode = anchorsNode.getFirstChild();
        do {
            if (anchorNamesNode.getNodeType() != 1 || !anchorNamesNode.getNodeName().equalsIgnoreCase("anchor")) continue;
            Element anchorElement = (Element)anchorNamesNode;
            retVal.add(anchorElement.getAttribute("name"));
        } while ((anchorNamesNode = anchorNamesNode.getNextSibling()) != null);
        if (retVal.size() == 0) {
            retVal = Collections.emptyList();
        }
        return retVal;
    }

    private void buildPublicCertStores(Node publicCertsNode) {
        Node publicCertNode = publicCertsNode.getFirstChild();
        do {
            if (publicCertNode.getNodeType() != 1 || !publicCertNode.getNodeName().equalsIgnoreCase("PublicCertStore")) continue;
            this.buildPublicCertStore(publicCertNode);
        } while ((publicCertNode = publicCertNode.getNextSibling()) != null);
    }

    private void buildPublicCertStore(Node publicCertNode) {
        Object resolverProvider = null;
        if (publicCertNode.getNodeType() == 1) {
            Element certNode = (Element)publicCertNode;
            String storeType = certNode.getAttribute("type");
            resolverProvider = storeType.equalsIgnoreCase("keystore") ? new KeyStoreCertificateStoreProvider(certNode.getAttribute("file"), certNode.getAttribute("filePass"), certNode.getAttribute("privKeyPass")) : (storeType.equalsIgnoreCase("dns") ? new DNSCertStoreProvider((Collection)Collections.EMPTY_LIST, null, (CertStoreCachePolicy)new DefaultCertStoreCachePolicy()) : new DNSCertStoreProvider((Collection)Collections.EMPTY_LIST, null, (CertStoreCachePolicy)new DefaultCertStoreCachePolicy()));
        }
        this.resolverProviders.add((Provider<CertificateResolver>)resolverProvider);
    }

    protected void buildPrivateCertStore(Node publicCertNode) {
        LdapCertificateStoreProvider resolverProvider = null;
        if (publicCertNode.getNodeType() == 1) {
            Element certNode = (Element)publicCertNode;
            String storeType = certNode.getAttribute("type");
            if (storeType.equalsIgnoreCase("keystore")) {
                resolverProvider = new KeyStoreCertificateStoreProvider(certNode.getAttribute("file"), certNode.getAttribute("filePass"), certNode.getAttribute("privKeyPass"));
            } else if (storeType.equalsIgnoreCase("ldap")) {
                resolverProvider = this.buildLdapCertificateStoreProvider(certNode, "LDAPPrivateCertStore");
            } else {
                throw new SmtpAgentException(SmtpAgentError.InvalidPrivateCertStoreSettings);
            }
        }
        this.privateCertModule = new PrivateCertStoreModule(resolverProvider);
    }

    private void buildRawMessageSettings(Node rawMsgNode) {
        if (rawMsgNode.getNodeType() == 1) {
            Element rawMsg = (Element)rawMsgNode;
            String saveFolder = rawMsg.getAttribute("saveFolder");
            RawMessageSettings settings = new RawMessageSettings();
            if (saveFolder != null) {
                settings.setSaveMessageFolder(new File(saveFolder));
            }
            this.rawSettings = settings;
        }
    }

    private void buildIncomingMessageSettings(Node incomingMsgNode) {
        if (incomingMsgNode.getNodeType() == 1) {
            Element incomingMsg = (Element)incomingMsgNode;
            String saveFolder = incomingMsg.getAttribute("saveFolder");
            ProcessIncomingSettings settings = new ProcessIncomingSettings();
            if (saveFolder != null) {
                settings.setSaveMessageFolder(new File(saveFolder));
            }
            this.incomingSettings = settings;
        }
    }

    private void buildOutgoingMessageSettings(Node outgoingMsgNode) {
        if (outgoingMsgNode.getNodeType() == 1) {
            Element outgoingMsg = (Element)outgoingMsgNode;
            String saveFolder = outgoingMsg.getAttribute("saveFolder");
            ProcessOutgoingSettings settings = new ProcessOutgoingSettings();
            if (saveFolder != null) {
                settings.setSaveMessageFolder(new File(saveFolder));
            }
            this.outgoingSettings = settings;
        }
    }

    private void buildBadMessageSettings(Node badMsgNode) {
        if (badMsgNode.getNodeType() == 1) {
            Element badMsg = (Element)badMsgNode;
            String saveFolder = badMsg.getAttribute("saveFolder");
            ProcessBadMessageSettings settings = new ProcessBadMessageSettings();
            if (saveFolder != null) {
                settings.setSaveMessageFolder(new File(saveFolder));
            }
            this.badSettings = settings;
        }
    }

    protected LdapCertificateStoreProvider buildLdapCertificateStoreProvider(Element anchorStoreNode, String cacheStoreName) {
        String[] ldapURL = anchorStoreNode.getAttribute("ldapURL").split(",");
        String ldapSearchBase = anchorStoreNode.getAttribute("ldapSearchBase");
        String ldapSearchAttr = anchorStoreNode.getAttribute("ldapSearchAttr");
        String ldapCertAttr = anchorStoreNode.getAttribute("ldapCertAttr");
        String ldapCertFormat = anchorStoreNode.getAttribute("ldapCertFormat");
        if (ldapURL[0].isEmpty() || ldapSearchBase.isEmpty() || ldapSearchAttr.isEmpty() || ldapCertAttr.isEmpty() || ldapCertFormat.isEmpty()) {
            throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat);
        }
        String ldapUser = anchorStoreNode.getAttribute("ldapUser");
        String ldapPassword = anchorStoreNode.getAttribute("ldapPassword");
        String ldapConnTimeout = anchorStoreNode.getAttribute("ldapConnTimeout");
        String ldapCertPassphrase = anchorStoreNode.getAttribute("ldapCertPassphrase");
        if (ldapCertFormat.equalsIgnoreCase("pkcs12") && ldapCertPassphrase.isEmpty()) {
            throw new SmtpAgentException(SmtpAgentError.InvalidConfigurationFormat);
        }
        LdapStoreConfiguration ldapStoreConfiguration = new LdapStoreConfiguration(ldapURL, ldapSearchBase, ldapSearchAttr, ldapCertAttr, ldapCertFormat);
        if (!ldapUser.isEmpty() || !ldapPassword.isEmpty()) {
            ldapStoreConfiguration.setEmployLdapAuthInformation(new EmployLdapAuthInformation(ldapUser, ldapPassword));
        }
        if (!ldapConnTimeout.isEmpty()) {
            ldapStoreConfiguration.setLdapConnectionTimeOut(ldapConnTimeout);
        }
        if (!ldapCertPassphrase.isEmpty()) {
            ldapStoreConfiguration.setLdapCertPassphrase(ldapCertPassphrase);
        }
        LdapCertificateStoreProvider ldapCertificateStoreProvider = new LdapCertificateStoreProvider(ldapStoreConfiguration, null, (CertStoreCachePolicy)new DefaultCertStoreCachePolicy());
        return ldapCertificateStoreProvider;
    }
}

