/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp;

import java.util.Collections;
import java.util.Map;
import org.nhindirect.gateway.smtp.DomainPostmaster;
import org.nhindirect.gateway.smtp.NotificationProducer;
import org.nhindirect.gateway.smtp.ProcessBadMessageSettings;
import org.nhindirect.gateway.smtp.ProcessIncomingSettings;
import org.nhindirect.gateway.smtp.ProcessOutgoingSettings;
import org.nhindirect.gateway.smtp.RawMessageSettings;

public class SmtpAgentSettings {
    private final Map<String, DomainPostmaster> domains;
    private final RawMessageSettings rawMessageSettings;
    private final ProcessOutgoingSettings outgoingSettings;
    private final ProcessIncomingSettings incomingSettings;
    private final ProcessBadMessageSettings badMessageSettings;
    private final NotificationProducer notificationProducer;

    public SmtpAgentSettings(Map<String, DomainPostmaster> domains, RawMessageSettings rawMessageSettings, ProcessOutgoingSettings outgoingSettings, ProcessIncomingSettings incomingSettings, ProcessBadMessageSettings badMessageSettings, NotificationProducer notificationProducer) {
        this.domains = domains;
        this.rawMessageSettings = rawMessageSettings;
        this.outgoingSettings = outgoingSettings;
        this.incomingSettings = incomingSettings;
        this.badMessageSettings = badMessageSettings;
        this.notificationProducer = notificationProducer;
    }

    public NotificationProducer getNotificationProducer() {
        return this.notificationProducer;
    }

    public Map<String, DomainPostmaster> getDomainPostmasters() {
        return Collections.unmodifiableMap(this.domains);
    }

    public RawMessageSettings getRawMessageSettings() {
        return this.rawMessageSettings;
    }

    public ProcessOutgoingSettings getOutgoingMessageSettings() {
        return this.outgoingSettings;
    }

    public ProcessIncomingSettings getIncomingMessageSettings() {
        return this.incomingSettings;
    }

    public ProcessBadMessageSettings getBadMessageSettings() {
        return this.badMessageSettings;
    }
}

