/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp;

import java.util.Collection;
import java.util.Collections;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.gateway.smtp.NotificationSettings;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.notifications.Notification;
import org.nhindirect.stagent.mail.notifications.NotificationCreator;
import org.nhindirect.stagent.mail.notifications.NotificationHelper;
import org.nhindirect.stagent.mail.notifications.NotificationMessage;
import org.nhindirect.stagent.mail.notifications.NotificationType;
import org.nhindirect.stagent.mail.notifications.ReportingUserAgent;

public class NotificationProducer
implements NotificationCreator {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(NotificationProducer.class);
    protected final NotificationSettings settings;

    public NotificationProducer(NotificationSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("Settings cannot be null");
        }
        this.settings = settings;
        StringBuilder builder = new StringBuilder("Notification settings:");
        builder.append("\n\r\tMDN Auto Response: " + settings.isAutoResponse());
        builder.append("\n\r\tMDN Producer Name: " + settings.getProductName());
        builder.append("\n\r\tMDN Response Test: " + settings.getText());
        LOGGER.debug((Object)builder.toString());
    }

    public Notification createNotification(InternetAddress address) {
        return this.createAck(address);
    }

    public Collection<NotificationMessage> produce(IncomingMessage envelope) {
        if (envelope == null) {
            throw new IllegalArgumentException();
        }
        if (!this.settings.isAutoResponse() || !envelope.hasDomainRecipients() || NotificationHelper.isMDN((Message)envelope.getMessage())) {
            LOGGER.info((Object)"No MDN messages to send.");
            return Collections.emptyList();
        }
        LOGGER.info((Object)"Generating MDN \"processed\" messages");
        Collection senders = envelope.getDomainRecipients().toInternetAddressCollection();
        Collection notifications = NotificationHelper.createNotificationMessages((Message)envelope.getMessage(), (Collection)senders, (NotificationCreator)this);
        return notifications;
    }

    public Collection<NotificationMessage> produce(Message msg, Collection<InternetAddress> recipients) {
        if (msg == null || recipients == null || recipients.size() == 0) {
            throw new IllegalArgumentException();
        }
        Collection<InternetAddress> senders = recipients;
        Collection notifications = NotificationHelper.createNotificationMessages((Message)msg, senders, (NotificationCreator)this);
        return notifications;
    }

    protected Notification createAck(InternetAddress address) {
        Notification notification = new Notification(NotificationType.Processed);
        if (this.settings.hasText()) {
            notification.setExplanation(this.settings.getText());
        }
        notification.setReportingAgent(new ReportingUserAgent(NHINDAddress.getHost((InternetAddress)address), this.settings.getProductName()));
        return notification;
    }

    public NotificationSettings getNotificationSettings() {
        return this.settings;
    }
}

