/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.gateway.smtp;

import com.google.inject.Injector;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.gateway.smtp.SmtpAgent;
import org.nhindirect.gateway.smtp.config.SmtpAgentConfig;
import org.nhindirect.stagent.MutableAgent;
import org.nhindirect.stagent.NHINDAgent;

public class GatewayState {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(GatewayState.class);
    protected static final long DEFAULT_SETTINGS_UPDATE_DELAY = 300000L;
    protected static GatewayState INSTANCE;
    protected final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    protected SmtpAgent smtpAgent;
    protected SmtpAgentConfig smtpAgentConfig;
    protected SettingsManager settingsManager;
    protected long settingsThreadDelay = 300000L;

    public static synchronized GatewayState getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GatewayState();
        }
        return INSTANCE;
    }

    private GatewayState() {
    }

    public void lockForProcessing() {
        this.readWriteLock.readLock().lock();
    }

    public void unlockFromProcessing() {
        this.readWriteLock.readLock().unlock();
    }

    public void lockForUpdating() {
        this.readWriteLock.writeLock().lock();
    }

    public void unlockFromUpdating() {
        this.readWriteLock.writeLock().unlock();
    }

    public synchronized void setSettingsUpdateInterval(long intervalInSeconds) {
        this.settingsThreadDelay = intervalInSeconds * 1000L;
    }

    public synchronized long getSettingsUpdateInterval() {
        return this.settingsThreadDelay / 1000L;
    }

    public synchronized void setSmtpAgent(SmtpAgent agent) {
        this.smtpAgent = agent;
    }

    public synchronized SmtpAgent getSmtpAgent() {
        return this.smtpAgent;
    }

    public synchronized void setSmptAgentConfig(SmtpAgentConfig config) {
        this.smtpAgentConfig = config;
    }

    public synchronized SmtpAgentConfig getSmtpAgentConfig() {
        return this.smtpAgentConfig;
    }

    public synchronized void startAgentSettingsManager() {
        if (this.smtpAgentConfig == null || this.smtpAgent == null) {
            throw new IllegalStateException("Agent config and settings must be set first.");
        }
        if (this.settingsManager != null) {
            throw new IllegalStateException("Settings manager is already running.");
        }
        this.settingsManager = new SettingsManager(this.smtpAgent, this.smtpAgentConfig, this.settingsThreadDelay);
        Thread managerThread = Executors.defaultThreadFactory().newThread(this.settingsManager);
        managerThread.setDaemon(true);
        managerThread.setName("SMTP Gateway State Update Thread");
        managerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopAgentSettingsManager() {
        if (this.settingsManager == null) {
            throw new IllegalStateException("Settings manager is not running.");
        }
        SettingsManager settingsManager = this.settingsManager;
        synchronized (settingsManager) {
            this.settingsManager.setRunning(false);
            this.settingsManager.notifyAll();
        }
        this.settingsManager = null;
    }

    public synchronized boolean isAgentSettingManagerRunning() {
        return this.settingsManager != null;
    }

    protected static class SettingsManager
    implements Runnable {
        private final SmtpAgent agent;
        private final SmtpAgentConfig config;
        private final long waitInterval;
        private boolean isRunning = true;

        public SettingsManager(SmtpAgent agent, SmtpAgentConfig config, long waitInterval) {
            this.agent = agent;
            this.config = config;
            this.waitInterval = waitInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NHINDAgent theAgent = this.agent.getAgent();
            if (!(theAgent instanceof MutableAgent)) {
                LOGGER.warn((Object)"The configured agent is not mutable.  Configuration changes cannot be applied.");
                return;
            }
            MutableAgent runningAgent = (MutableAgent)theAgent;
            while (this.isRunning()) {
                NHINDAgent newAgent = null;
                try {
                    LOGGER.info((Object)"Refreshing agent settings from configuration.");
                    Injector injector = this.config.getAgentInjector();
                    newAgent = (NHINDAgent)injector.getInstance(NHINDAgent.class);
                    if (!(newAgent instanceof MutableAgent)) {
                        LOGGER.warn((Object)"The agent configuration does not allow attributes to be retrieved.  Cannot update currently running agent.");
                        return;
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn((Object)"Could not get new agent settings.  Configuration may be in an invalid state or not reachable.", t);
                    continue;
                }
                MutableAgent newMutableAgent = (MutableAgent)newAgent;
                INSTANCE.lockForUpdating();
                try {
                    runningAgent.setDomains(newMutableAgent.getDomains());
                    runningAgent.setTrustAnchorResolver(newMutableAgent.getTrustAnchors());
                    runningAgent.setCryptographer(newMutableAgent.getCryptographer());
                    runningAgent.setPrivateCertResolver(newMutableAgent.getPrivateCertResolver());
                    runningAgent.setPublicCertResolvers(newMutableAgent.getPublicCertResolvers());
                    runningAgent.setPolicyFilter(newMutableAgent.getPolicyFilter());
                    runningAgent.setPrivatePolicyResolver(newMutableAgent.getPrivatePolicyResolver());
                    runningAgent.setPublicPolicyResolver(newMutableAgent.getPublicPolicyResolver());
                    runningAgent.setTrustModel(newMutableAgent.getTrustModel());
                }
                finally {
                    INSTANCE.unlockFromUpdating();
                }
                SettingsManager settingsManager = this;
                synchronized (settingsManager) {
                    try {
                        if (this.isRunning()) {
                            this.wait(this.waitInterval);
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }

        public synchronized void setRunning(boolean running) {
            this.isRunning = running;
        }

        public synchronized boolean isRunning() {
            return this.isRunning;
        }
    }
}

