/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.filterchain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Appendable;
import org.glassfish.grizzly.Appender;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.ProcessorExecutor;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.InternalContextImpl;
import org.glassfish.grizzly.filterchain.InvokeAction;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.RerunFilterAction;
import org.glassfish.grizzly.filterchain.StopAction;
import org.glassfish.grizzly.filterchain.SuspendAction;
import org.glassfish.grizzly.filterchain.SuspendingStopAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.memory.Buffers;

public final class FilterChainContext
implements AttributeStorage {
    private static final Logger logger = Grizzly.logger(FilterChainContext.class);
    private static final ThreadCache.CachedTypeIndex<FilterChainContext> CACHE_IDX = ThreadCache.obtainIndex(FilterChainContext.class, 4);
    public static final int NO_FILTER_INDEX = Integer.MIN_VALUE;
    private static final NextAction INVOKE_ACTION = new InvokeAction();
    private static final NextAction STOP_ACTION = new StopAction();
    private static final NextAction SUSPEND_ACTION = new SuspendAction();
    private static final NextAction RERUN_FILTER_ACTION = new RerunFilterAction();
    private static final NextAction SUSPENDING_STOP_ACTION = new SuspendingStopAction();
    final InternalContextImpl internalContext = new InternalContextImpl(this);
    final TransportContext transportFilterContext = new TransportContext();
    private volatile State state;
    private Operation operation = Operation.NONE;
    private AttributeHolder customAttributes;
    protected FutureImpl<FilterChainContext> operationCompletionFuture;
    protected CompletionHandler<FilterChainContext> operationCompletionHandler;
    private final Runnable contextRunnable;
    private Object message;
    protected FilterChainEvent event;
    private Object address;
    private int filterIdx;
    private int startIdx;
    private int endIdx;
    private final StopAction cachedStopAction = new StopAction();
    private final InvokeAction cachedInvokeAction = new InvokeAction();
    private final List<CompletionListener> completionListeners = new ArrayList<CompletionListener>(2);

    public static FilterChainContext create(Connection connection) {
        FilterChainContext context = ThreadCache.takeFromCache(CACHE_IDX);
        if (context == null) {
            context = new FilterChainContext();
        }
        context.setConnection(connection);
        context.getTransportContext().isBlocking = connection.isBlocking();
        return context;
    }

    public FilterChainContext() {
        this.filterIdx = Integer.MIN_VALUE;
        this.contextRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (FilterChainContext.this.state == State.SUSPEND) {
                        FilterChainContext.this.state = State.RUNNING;
                    }
                    ProcessorExecutor.execute(FilterChainContext.this.internalContext);
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Exception during running Processor", e);
                }
            }
        };
    }

    public Runnable suspend() {
        this.state = State.SUSPEND;
        return this.getRunnable();
    }

    public void resume() {
        this.getRunnable().run();
    }

    public State state() {
        return this.state;
    }

    public int nextFilterIdx() {
        return ++this.filterIdx;
    }

    public int previousFilterIdx() {
        return --this.filterIdx;
    }

    public int getFilterIdx() {
        return this.filterIdx;
    }

    public void setFilterIdx(int index) {
        this.filterIdx = index;
    }

    public int getStartIdx() {
        return this.startIdx;
    }

    public void setStartIdx(int startIdx) {
        this.startIdx = startIdx;
    }

    public int getEndIdx() {
        return this.endIdx;
    }

    public void setEndIdx(int endIdx) {
        this.endIdx = endIdx;
    }

    public FilterChain getFilterChain() {
        return (FilterChain)this.internalContext.getProcessor();
    }

    public Connection getConnection() {
        return this.internalContext.getConnection();
    }

    void setConnection(Connection connection) {
        this.internalContext.setConnection(connection);
    }

    public <T> T getMessage() {
        return (T)this.message;
    }

    public void setMessage(Object message) {
        this.message = message;
    }

    public Object getAddress() {
        return this.address;
    }

    public void setAddress(Object address) {
        this.address = address;
    }

    protected final Runnable getRunnable() {
        return this.contextRunnable;
    }

    public TransportContext getTransportContext() {
        return this.transportFilterContext;
    }

    public final Context getInternalContext() {
        return this.internalContext;
    }

    Operation getOperation() {
        return this.operation;
    }

    void setOperation(Operation operation) {
        this.operation = operation;
    }

    public NextAction getInvokeAction(Object remainder) {
        this.cachedInvokeAction.setRemainder(remainder);
        return this.cachedInvokeAction;
    }

    public NextAction getInvokeAction() {
        return INVOKE_ACTION;
    }

    public NextAction getStopAction() {
        return STOP_ACTION;
    }

    public NextAction getSuspendingStopAction() {
        return SUSPENDING_STOP_ACTION;
    }

    public <E> NextAction getStopAction(E remainder, Appender<E> appender) {
        this.cachedStopAction.setRemainder(remainder, appender);
        return this.cachedStopAction;
    }

    public NextAction getStopAction(Appendable appendable) {
        this.cachedStopAction.setRemainder(appendable);
        return this.cachedStopAction;
    }

    public NextAction getStopAction(Object unknownObject) {
        if (unknownObject instanceof Buffer) {
            return this.getStopAction((Buffer)unknownObject, Buffers.BUFFER_APPENDER);
        }
        return this.getStopAction((Appendable)unknownObject);
    }

    public NextAction getSuspendAction() {
        return SUSPEND_ACTION;
    }

    public NextAction getRerunFilterAction() {
        return RERUN_FILTER_ACTION;
    }

    public ReadResult read() throws IOException {
        FilterChainContext newContext = this.getFilterChain().obtainFilterChainContext(this.getConnection());
        newContext.setOperation(Operation.READ);
        newContext.getTransportContext().configureBlocking(true);
        newContext.setStartIdx(0);
        newContext.setFilterIdx(0);
        newContext.setEndIdx(this.filterIdx);
        newContext.customAttributes = this.getAttributes();
        ReadResult rr = this.getFilterChain().read(newContext);
        newContext.completeAndRecycle();
        return rr;
    }

    public void write(Object message) throws IOException {
        this.write(null, message, null);
    }

    public void write(Object message, CompletionHandler<WriteResult> completionHandler) throws IOException {
        this.write(null, message, completionHandler);
    }

    public void write(Object address, Object message, CompletionHandler<WriteResult> completionHandler) throws IOException {
        FilterChainContext newContext = this.getFilterChain().obtainFilterChainContext(this.getConnection());
        newContext.setOperation(Operation.WRITE);
        newContext.getTransportContext().configureBlocking(this.transportFilterContext.isBlocking());
        newContext.setMessage(message);
        newContext.setAddress(address);
        newContext.transportFilterContext.completionHandler = completionHandler;
        newContext.setStartIdx(this.filterIdx - 1);
        newContext.setFilterIdx(this.filterIdx - 1);
        newContext.setEndIdx(-1);
        newContext.customAttributes = this.getAttributes();
        ProcessorExecutor.execute(newContext.internalContext);
    }

    public void flush(CompletionHandler completionHandler) throws IOException {
        FilterChainContext newContext = this.getFilterChain().obtainFilterChainContext(this.getConnection());
        newContext.setOperation(Operation.EVENT);
        newContext.event = TransportFilter.createFlushEvent(null, completionHandler);
        newContext.getTransportContext().configureBlocking(this.transportFilterContext.isBlocking());
        newContext.setAddress(this.address);
        newContext.setStartIdx(this.filterIdx - 1);
        newContext.setFilterIdx(this.filterIdx - 1);
        newContext.setEndIdx(-1);
        newContext.customAttributes = this.getAttributes();
        ProcessorExecutor.execute(newContext.internalContext);
    }

    public void notifyUpstream(FilterChainEvent event) throws IOException {
        this.notifyUpstream(event, null);
    }

    public void notifyUpstream(FilterChainEvent event, CompletionHandler<FilterChainContext> completionHandler) throws IOException {
        FilterChainContext newContext = this.getFilterChain().obtainFilterChainContext(this.getConnection());
        newContext.setOperation(Operation.EVENT);
        newContext.event = event;
        newContext.setAddress(this.address);
        newContext.setStartIdx(this.filterIdx + 1);
        newContext.setFilterIdx(this.filterIdx + 1);
        newContext.setEndIdx(this.endIdx);
        newContext.customAttributes = this.getAttributes();
        newContext.operationCompletionHandler = completionHandler;
        ProcessorExecutor.execute(newContext.internalContext);
    }

    public void notifyDownstream(FilterChainEvent event) throws IOException {
        this.notifyDownstream(event, null);
    }

    public void notifyDownstream(FilterChainEvent event, CompletionHandler<FilterChainContext> completionHandler) throws IOException {
        FilterChainContext newContext = this.getFilterChain().obtainFilterChainContext(this.getConnection());
        newContext.setOperation(Operation.EVENT);
        newContext.event = event;
        newContext.setAddress(this.address);
        newContext.setStartIdx(this.filterIdx - 1);
        newContext.setFilterIdx(this.filterIdx - 1);
        newContext.setEndIdx(-1);
        newContext.customAttributes = this.getAttributes();
        newContext.operationCompletionHandler = completionHandler;
        ProcessorExecutor.execute(newContext.internalContext);
    }

    public void fail(Throwable error) {
        this.getFilterChain().fail(this, error);
    }

    @Override
    public AttributeHolder getAttributes() {
        if (this.customAttributes == null) {
            return this.internalContext.getAttributes();
        }
        return this.customAttributes;
    }

    public final void addCompletionListener(CompletionListener listener) {
        this.completionListeners.add(listener);
    }

    public final boolean removeCompletionListener(CompletionListener listener) {
        return this.completionListeners.remove(listener);
    }

    public void reset() {
        this.message = null;
        this.event = null;
        this.address = null;
        this.filterIdx = Integer.MIN_VALUE;
        this.state = State.RUNNING;
        this.operationCompletionFuture = null;
        this.operationCompletionHandler = null;
        this.customAttributes = null;
        this.operation = Operation.NONE;
        this.completionListeners.clear();
        this.internalContext.reset();
        this.transportFilterContext.reset();
    }

    public void completeAndRecycle() {
        this.notifyComplete();
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(384);
        sb.append("FilterChainContext [");
        sb.append("connection=").append(this.getConnection());
        sb.append(", operation=").append((Object)this.getOperation());
        sb.append(", message=").append(this.getMessage());
        sb.append(", address=").append(this.getAddress());
        sb.append(']');
        return sb.toString();
    }

    static Operation ioEvent2Operation(IOEvent ioEvent) {
        switch (ioEvent) {
            case READ: {
                return Operation.READ;
            }
            case WRITE: {
                return Operation.WRITE;
            }
            case ACCEPTED: {
                return Operation.ACCEPT;
            }
            case CONNECTED: {
                return Operation.CONNECT;
            }
            case CLOSED: {
                return Operation.CLOSE;
            }
        }
        return Operation.NONE;
    }

    void notifyComplete() {
        int size = this.completionListeners.size();
        for (int i = 0; i < size; ++i) {
            this.completionListeners.get(i).onComplete(this);
        }
    }

    public static interface CompletionListener {
        public void onComplete(FilterChainContext var1);
    }

    public static final class TransportContext {
        private boolean isBlocking;
        CompletionHandler completionHandler;
        FutureImpl future;

        public void configureBlocking(boolean isBlocking) {
            this.isBlocking = isBlocking;
        }

        public boolean isBlocking() {
            return this.isBlocking;
        }

        public CompletionHandler getCompletionHandler() {
            return this.completionHandler;
        }

        public void setCompletionHandler(CompletionHandler completionHandler) {
            this.completionHandler = completionHandler;
        }

        public FutureImpl getFuture() {
            return this.future;
        }

        public void setFuture(FutureImpl future) {
            this.future = future;
        }

        void reset() {
            this.isBlocking = false;
            this.completionHandler = null;
            this.future = null;
        }
    }

    public static enum Operation {
        NONE,
        ACCEPT,
        CONNECT,
        READ,
        WRITE,
        EVENT,
        CLOSE;

    }

    public static enum State {
        RUNNING,
        SUSPEND;

    }
}

