/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store.dao.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.dao.AddressDao;
import org.nhindirect.config.store.dao.DomainDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class DomainDaoImpl
implements DomainDao {
    @PersistenceContext
    @Autowired
    private EntityManager entityManager;
    @Autowired
    private AddressDao addressDao;
    private static final Log log = LogFactory.getLog(DomainDaoImpl.class);

    @Override
    @Transactional(readOnly=true)
    public int count() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        Long result = (Long)this.entityManager.createQuery("select count(d) from Domain d").getSingleResult();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: " + result.intValue()));
        }
        return result.intValue();
    }

    @Override
    @Transactional(readOnly=false)
    public void add(Domain item) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (item.getDomainName() == null || item.getDomainName().isEmpty()) {
            throw new ConfigurationStoreException("Domain name cannot be empty or null");
        }
        if (item != null) {
            String pm = item.getPostMasterEmail();
            Long pmId = item.getPostmasterAddressId();
            Collection<Address> addresses = item.getAddresses();
            if (pmId != null && pmId == 0L) {
                item.setPostmasterAddressId(null);
            }
            item.setAddresses(null);
            item.setCreateTime(Calendar.getInstance());
            item.setUpdateTime(item.getCreateTime());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Calling JPA to persist the Domain");
            }
            this.entityManager.persist((Object)item);
            this.entityManager.flush();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Persisted the bare Domain");
            }
            boolean needUpdate = false;
            if (addresses != null && addresses.size() > 0) {
                item.setAddresses(addresses);
                needUpdate = true;
            }
            if (pm != null && pm.length() > 0) {
                item.setPostMasterEmail(pm);
                needUpdate = true;
            }
            if (needUpdate) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Updating the domain with Address info");
                }
                this.update(item);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returned from JPA: Domain ID=" + item.getId()));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void update(Domain item) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (item != null) {
            item.setUpdateTime(Calendar.getInstance());
            if (item.getPostMasterEmail() != null && item.getPostMasterEmail().length() > 0) {
                boolean found = false;
                Iterator<Address> addrs = item.getAddresses().iterator();
                while (addrs.hasNext()) {
                    if (!addrs.next().getEmailAddress().equals(item.getPostMasterEmail())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding new postmaster email address: " + item.getPostMasterEmail()));
                    }
                    item.getAddresses().add(new Address(item, item.getPostMasterEmail(), "Postmaster"));
                }
            }
            for (Address address : item.getAddresses()) {
                if (address.getId() != null && address.getId() != 0L) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding " + address.toString() + " to database"));
                }
                this.addressDao.add(address);
            }
            if (item.getPostmasterAddressId() == null || item.getPostmasterAddressId() == 0L) {
                for (Address address : item.getAddresses()) {
                    if (!address.getDisplayName().equals("Postmaster")) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Linking domain's postmaster email address to " + address.toString()));
                    }
                    item.setPostmasterAddressId(address.getId());
                    break;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Calling JPA to perform update...");
            }
            this.entityManager.merge((Object)item);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void save(Domain item) {
        this.update(item);
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(String name) {
        Domain domain;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if ((domain = this.getDomainByName(name)) != null) {
            this.entityManager.remove((Object)domain);
        } else {
            log.warn((Object)("No domain matching the name: " + name + " found.  Unable to delete."));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(Long anId) {
        Domain domain;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if ((domain = this.getDomain(anId)) != null) {
            this.entityManager.remove((Object)domain);
        } else {
            log.warn((Object)("No domain matching the id: " + anId + " found.  Unable to delete."));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Domain getDomainByName(String name) {
        Query select;
        Query paramQuery;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        Domain result = null;
        if (name != null && (paramQuery = (select = this.entityManager.createQuery("SELECT DISTINCT d from Domain d WHERE UPPER(d.domainName) = ?1")).setParameter(1, (Object)name.toUpperCase(Locale.getDefault()))).getResultList().size() > 0) {
            result = (Domain)paramQuery.getSingleResult();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Domain> getDomains(List<String> names, EntityStatus status) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        List result = null;
        Query select = null;
        if (names != null) {
            StringBuffer nameList = new StringBuffer("(");
            for (String aName : names) {
                if (nameList.length() > 1) {
                    nameList.append(", ");
                }
                nameList.append("'").append(aName.toUpperCase(Locale.getDefault())).append("'");
            }
            nameList.append(")");
            String query = "SELECT d from Domain d WHERE UPPER(d.domainName) IN " + nameList.toString();
            if (status != null) {
                select = this.entityManager.createQuery(query + " AND d.status = ?1");
                select.setParameter(1, (Object)status);
            } else {
                select = this.entityManager.createQuery(query);
            }
        } else if (status != null) {
            select = this.entityManager.createQuery("SELECT d from Domain d WHERE d.status = ?1");
            select.setParameter(1, (Object)status);
        } else {
            select = this.entityManager.createQuery("SELECT d from Domain d");
        }
        List rs = select.getResultList();
        result = rs.size() != 0 && rs.get(0) instanceof Domain ? rs : new ArrayList();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Domain> listDomains(String name, int count) {
        List rs;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        List result = null;
        Query select = null;
        if (name != null) {
            select = this.entityManager.createQuery("SELECT d from Domain d WHERE UPPER(d.domainName) = ?1");
            select.setParameter(1, (Object)name.toUpperCase(Locale.getDefault()));
        } else {
            select = this.entityManager.createQuery("SELECT d from Domain d");
        }
        if (count > 0) {
            select.setMaxResults(count);
        }
        if ((rs = select.getResultList()).size() != 0 && rs.get(0) instanceof Domain) {
            result = rs;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
        return result;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Domain> searchDomain(String name, EntityStatus status) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        ArrayList<Domain> result = null;
        StringBuffer query = new StringBuffer("");
        Query select = null;
        if (name != null) {
            String search = name.replace('*', '%').toUpperCase(Locale.getDefault());
            search.replace('?', '_');
            query.append("SELECT d from Domain d WHERE UPPER(d.domainName) LIKE ?1 ");
            if (status != null) {
                query.append("AND d.status = ?2");
                select = this.entityManager.createQuery(query.toString());
                select.setParameter(1, (Object)search);
                select.setParameter(2, (Object)status);
            } else {
                select = this.entityManager.createQuery(query.toString());
                select.setParameter(1, (Object)search);
            }
        } else if (status != null) {
            query.append("SELECT d from Domain d WHERE d.status LIKE ?1");
            select = this.entityManager.createQuery(query.toString());
            select.setParameter(1, (Object)status);
        } else {
            select = this.entityManager.createQuery("SELECT d from Domain d");
        }
        result = select.getResultList();
        if (result == null) {
            result = new ArrayList<Domain>();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public Domain getDomain(Long id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        Domain result = null;
        if (id != null && id > 0L) {
            result = (Domain)this.entityManager.find(Domain.class, (Object)id);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
        return result;
    }

    public void setAddressDao(AddressDao aDao) {
        this.addressDao = aDao;
    }

    private AddressDao getAddressDao() {
        return this.addressDao;
    }
}

