/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.IOException;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.bouncycastle.util.Arrays;
import org.nhindirect.config.store.util.DNSRecordUtils;

@Entity
@Table(name="dnsrecord")
public class DNSRecord {
    private long id;
    private String name;
    private int type;
    private int dclass;
    private long ttl;
    private byte[] data;
    private Calendar createTime;

    @Id
    @Column(name="id", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="type")
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Column(name="dclass")
    public int getDclass() {
        return this.dclass;
    }

    public void setDclass(int dclass) {
        this.dclass = dclass;
    }

    @Column(name="ttl")
    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getCreateTime() {
        if (this.createTime == null) {
            this.setCreateTime(Calendar.getInstance());
        }
        return this.createTime;
    }

    public void setCreateTime(Calendar timestamp) {
        this.createTime = timestamp;
    }

    @Column(name="data", length=8192)
    @Lob
    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public static DNSRecord fromWire(byte[] data) throws IOException {
        return DNSRecordUtils.fromWire(data);
    }

    public static byte[] toWire(DNSRecord rec) throws IOException {
        return DNSRecordUtils.toWire(rec);
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof DNSRecord)) {
            return false;
        }
        DNSRecord rec = (DNSRecord)ob;
        return rec.dclass == this.dclass && rec.type == this.type && rec.name.equals(rec.name) && Arrays.areEqual((byte[])rec.getData(), (byte[])this.data);
    }
}

