/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.service.impl;

import java.net.URL;
import java.util.Properties;
import javax.jws.WebService;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.service.ValidateService;
import org.nhindirect.gateway.smtp.SmtpAgent;
import org.nhindirect.gateway.smtp.SmtpAgentException;
import org.nhindirect.gateway.smtp.SmtpAgentFactory;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;

@WebService(endpointInterface="org.nhindirect.config.service.ValidateService")
public class ValidateServiceImpl
implements ValidateService {
    private static final Log log = LogFactory.getLog(ValidateServiceImpl.class);

    public void init() {
        log.info((Object)"ValidateService initialized");
    }

    @Override
    public boolean validateTrust(String sender_address, String address) throws ConfigurationServiceException {
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        try {
            NHINDAddress sender = new NHINDAddress(sender_address);
            NHINDAddress recipient = new NHINDAddress(address);
            NHINDAddressCollection recipients = new NHINDAddressCollection();
            recipients.add((Object)recipient);
            MimeMessage mm = new MimeMessage(session);
            mm.setFrom((Address)sender);
            mm.addRecipient(MimeMessage.RecipientType.TO, (Address)recipient);
            mm.setSubject("");
            mm.setText("");
            try {
                SmtpAgent agent = SmtpAgentFactory.createAgent((URL)new URL("http://localhost:8081/config-service/ConfigurationService"));
                agent.processMessage(mm, recipients, sender);
            }
            catch (SmtpAgentException e) {
                log.error((Object)("Failed to create the SMTP agent: " + e.getMessage()), (Throwable)e);
                throw new MessagingException("Failed to create the SMTP agent: " + e.getMessage(), (Exception)((Object)e));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

