/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.service.AnchorService;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.service.impl.CertificateGetOptions;
import org.nhindirect.config.store.Anchor;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.dao.AnchorDao;
import org.springframework.beans.factory.annotation.Autowired;

@WebService(endpointInterface="org.nhindirect.config.service.AnchorService")
public class AnchorServiceImpl
implements AnchorService {
    private static final Log log = LogFactory.getLog(AnchorServiceImpl.class);
    private AnchorDao dao;

    @Override
    public void addAnchors(Collection<Anchor> anchors) throws ConfigurationServiceException {
        if (anchors != null && anchors.size() > 0) {
            for (Anchor anchor : anchors) {
                this.dao.add(anchor);
            }
        }
    }

    @Override
    public Anchor getAnchor(String owner, String thumbprint, CertificateGetOptions options) throws ConfigurationServiceException {
        ArrayList<String> owners = new ArrayList<String>();
        owners.add(owner);
        List anchors = this.dao.list(owners);
        if (anchors == null || anchors.size() == 0) {
            return null;
        }
        for (Anchor anchor : anchors) {
            if (!anchor.getThumbprint().equalsIgnoreCase(thumbprint)) continue;
            return anchor;
        }
        return null;
    }

    @Override
    public Collection<Anchor> getAnchors(Collection<Long> anchorIds, CertificateGetOptions options) throws ConfigurationServiceException {
        if (anchorIds == null || anchorIds.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Long> ids = new ArrayList<Long>(anchorIds);
        return this.dao.listByIds(ids);
    }

    @Override
    public Collection<Anchor> getAnchorsForOwner(String owner, CertificateGetOptions options) throws ConfigurationServiceException {
        ArrayList<String> owners = new ArrayList<String>();
        owners.add(owner);
        return this.dao.list(owners);
    }

    @Override
    public Collection<Anchor> getIncomingAnchors(String owner, CertificateGetOptions options) throws ConfigurationServiceException {
        Collection<Anchor> anchors = this.getAnchorsForOwner(owner, options);
        if (anchors == null || anchors.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Anchor> retList = new ArrayList<Anchor>();
        for (Anchor anchor : anchors) {
            if (!anchor.isIncoming()) continue;
            retList.add(anchor);
        }
        return retList;
    }

    @Override
    public Collection<Anchor> getOutgoingAnchors(String owner, CertificateGetOptions options) throws ConfigurationServiceException {
        Collection<Anchor> anchors = this.getAnchorsForOwner(owner, options);
        if (anchors == null || anchors.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Anchor> retList = new ArrayList<Anchor>();
        for (Anchor anchor : anchors) {
            if (!anchor.isOutgoing()) continue;
            retList.add(anchor);
        }
        return retList;
    }

    @Override
    public void setAnchorStatusForOwner(String owner, EntityStatus status) throws ConfigurationServiceException {
        this.dao.setStatus(owner, status);
    }

    @Override
    public Collection<Anchor> listAnchors(Long lastAnchorID, int maxResults, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.dao.listAll();
    }

    @Override
    public void removeAnchors(Collection<Long> anchorIds) throws ConfigurationServiceException {
        if (anchorIds == null || anchorIds.size() == 0) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(anchorIds);
        this.dao.delete(ids);
    }

    @Override
    public void removeAnchorsForOwner(String owner) throws ConfigurationServiceException {
        this.dao.delete(owner);
    }

    @Autowired
    public void setDao(AnchorDao dao) {
        this.dao = dao;
    }

    public AnchorDao getDao() {
        return this.dao;
    }
}

