/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package gov.vha.vuid.rest.session;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.Map;

import javax.ws.rs.client.WebTarget;

import gov.vha.isaac.ochre.api.LookupService;
import gov.vha.isaac.rest.services.ClientService;
import gov.vha.isaac.rest.utils.CommonPrismeServiceUtils;
import gov.vha.vuid.rest.ApplicationConfig;

/**
 * 
 * {@link PrismeServiceUtils}
 *
 * @author <a href="mailto:joel.kniaz.list@gmail.com">Joel Kniaz</a>
 *
 */
public class PrismeServiceUtils {
	@SuppressWarnings("unused")
	private static Logger log = LogManager.getLogger(PrismeServiceUtils.class);

	private PrismeServiceUtils() {}
	
	protected static String getConfigProperty(String propertyName)
	{
		switch(propertyName)
		{
			//https://DNS              :PORT/rails_prisme/roles/get_roles_by_token.json
			case "prisme_roles_by_token_url" :
				return ApplicationConfig.getInstance().getProtocol() + "://" + ApplicationConfig.getInstance().getHostname() + ":" + ApplicationConfig.getInstance().getPort() 
						+ "/rails_prisme/roles/get_roles_by_token.json";
			default:
				throw new RuntimeException("Unknown property Name '" + propertyName + "'");
		}
	}

	public static String getResultJsonFromPrisme(String targetStr, String pathStr, Map<String, String> params) {
		ClientService clientService = LookupService.getService(ClientService.class);
		WebTarget target = clientService.getClient().target(targetStr);
		target = target.path(pathStr);
		
		return CommonPrismeServiceUtils.getResultJsonFromPrisme(target, params);
	}
}
