/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package gov.vha.vuid.rest.session;

import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.hk2.api.Rank;
import org.jvnet.hk2.annotations.Service;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import gov.vha.isaac.ochre.api.User;
import gov.vha.isaac.ochre.api.PrismeRole;

/**
 * The Class PrismeIntegratedUserService
 *
 * {@link PrismeIntegratedUserService}
 * 
 * @author <a href="mailto:joel.kniaz.list@gmail.com">Joel Kniaz</a>
 */
@Service(name="rest-prismeUserService")
@Rank(value = 10)
@Singleton
public class PrismeIntegratedUserService implements PrismeUserService {
	private static Logger log = LogManager.getLogger(PrismeIntegratedUserService.class);
	
	//private Properties prismeProperties_ = null;

	protected PrismeIntegratedUserService() {
		//for HK2
	}

	/**
	 * 
	 * @see gov.vha.vuid.rest.session.PrismeUserService#getUser(java.lang.String)
	 */
	@Override
	public Optional<User> getUser(String ssoToken) {
		try {
			return Optional.of(getUserFromPrisme(ssoToken));
		} catch (Exception e) {
			log.error("Failed to retreive user from prisme", e);
			return Optional.empty();
		}
	}

	/**
	 * @see gov.vha.isaac.ochre.api.UserRoleService#getUserRoles(java.util.UUID)
	 */
	@Override
	public User getUser(UUID userId)
	{
		throw new UnsupportedOperationException();
	}

	// Private helpers
	protected User getUserFromPrisme(String ssoToken) throws JsonParseException, JsonMappingException, IOException {
//		/*
//		 * Example URL for get_roles_by_token
//		 * URL url = new URL("https://DNS                     /rails_prisme/roles/get_roles_by_token.json?token=" + token);
//		 */
//		//String json = "{\"roles\":[{\"id\":10000,\"name\":\"read_only\",\"resource_id\":null,\"resource_type\":null,\"created_at\":\
		//"2016-09-13T14:48:18.000Z\",\"updated_at\":\"2016-09-13T14:48:18.000Z\"}],\"token_parsed?\":true,\"user\":\"DNS   ArmbrD\",\"type\":\"ssoi\",\"id\":10005}";
		String prismeRolesByTokenUrlStr = PrismeServiceUtils.getConfigProperty("prisme_roles_by_token_url");
		URL url = new URL(prismeRolesByTokenUrlStr);
		User user = UserServiceUtils.getUserFromUrl(url, ssoToken);
		log.trace("Retrieved from " + prismeRolesByTokenUrlStr + " user=\"" + user + "\"");
		return user;
	}

	/**
	 * @see gov.vha.isaac.ochre.api.UserRoleService#getAllUserRoles()
	 */
	@Override
	public Set<PrismeRole> getAllPossibleUserRoles()
	{
		throw new UnsupportedOperationException();
	}
}
