package gov.vha.vuid.rest.data;

import java.util.Optional;

import org.jvnet.hk2.annotations.Contract;
import gov.vha.isaac.rest.api.data.vuid.RestVuidBlockData;
import gov.vha.isaac.rest.api.exceptions.RestException;

@Contract
public interface VuidService {

	/**
	 * Checks the database connection validity using a JDBC method without 
	 * running a query and checking the result.
	 * 
	 * @return true if the database connection is valid, false otherwise
	 */
	boolean isReady();
	
	/**
	 * Production mode is returning 'real' (positive) VUID values. It
	 * defaults to false, which will always return negative VUIDs.
	 * 
	 * @return true if using real VUIDs
	 */
	public boolean isProductionMode();
	
	/**
	 * Validates a VUID. If a VUID is less than the next vuid
	 * stored in the database, then it is considered 'valid'
	 * (as a number, no check if it's been used).
	 * 
	 * So we don't forget why this is:
	 * 
	 	15:47 Neill Robins
		Are the VUIDs going to come in negative values in test cases?
		15:49 Dan Armbrust
		bit of an open question how much we should validate when in test mode with negative vuids.
		it may be, that we don't do this step when in test mode.
		because the test would be pointless, if we aren't the authority server.
		but when we are, we would do the test.
		15:51 Neill Robins
		I'm curious how testers will test this part
		Or will they?
		15:51 Dan Armbrust
		they can put it in 'real'mode
		though they know it isn't in real mode
	 *
	 * @param vuidToValidate The VUID that should be validated
	 * @return true, if the VUID is valid, false if it's certain conditions aren't met, an excpetion is thrown for a bad VUID
	 */
	public boolean isVuidValid(long vuidToValidate) throws RestException;
	
	/**
	 * The public method to request a single, or block of, VUIDs.
	 * 
	 * @param blocksize The number of VUIDs requested
	 * @param username The username of the requester
	 * @param reason The reason given for the request
	 * @return A RestVuidBlockData object with the block start and end values
	 */
	public RestVuidBlockData requestVuids(int blocksize, String username, String reason)
			throws RestException;
}
