git VUID-Rest 

Simplified VUID APIs with REST access

--------------------------------------------------------
--  DDL for Table VUID
---------------------------------------------------
	CREATE TABLE "VTS_V12"."VUID" 
	(	"ID" NUMBER(19,0), 
		"ENDVUID" NUMBER(19,0), 
		"REQUESTDATE" TIMESTAMP (6), 
		"REQUESTREASON" VARCHAR2(255 CHAR), 
		"STARTVUID" NUMBER(19,0), 
		"USERINITIALS" VARCHAR2(255 CHAR)
	)

Notes on server support:

- The standalone VUID-rest service must be deployed in the same web server as PRISME and named "vuid-rest", as ISAAC-rest's VUID allocate API constructs the 
base URL for VUID-rest from its prisme.properties file property "prisme_root", i.e. "https://DNS:PORT/rails_prisme" becomes 
"https://DNS:PORT/vuid-rest."

- To run HP Fortify scan (assuming Fortify application and license installed)
	$ mvn -Dmaven.test.skip=true -Dfortify.sca.buildId=vuid-rest -Dfortify.sca.toplevel.artifactId=isaac-parent com.hpe.security.fortify.maven.plugin:sca-maven-plugin:clean
	$ mvn -Dmaven.test.skip=true -Dfortify.sca.buildId=vuid-rest -Dfortify.sca.toplevel.artifactId=isaac-parent com.hpe.security.fortify.maven.plugin:sca-maven-plugin:translate
	$ mvn -Dmaven.test.skip=true -Dfortify.sca.buildId=vuid-rest -Dfortify.sca.toplevel.artifactId=isaac-parent com.hpe.security.fortify.maven.plugin:sca-maven-plugin:scan
	
- Check API ChangeLog.md for API updates

Notes on Configuration:

To override any of the default settings, place a file named custom-vuid-rest.properties in the vuid.data.path location (default: /app/vuidServerData). Any and all key=value pairs in that file will take 
precedence the default application configuration parameters.

The most important options to note are:

prisme.data.path : Where Prisme writes to and where we expect to find the database configuration YAML file (database_vuid.yml), defaults to /app/prismeData

vuid.data.path : Where the VUID-rest deployment will store data, which may need to be created and defaults to /app/vuidServerData

vuid.request.max_blocksize : The maximum number of VUIDs allowed in a single request, defaults to 1000000 (1,000,000) 
