package gov.va.med.term.icd10.propertyTypes;

import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.BPT_Annotations;
import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.Property;
import gov.vha.isaac.MetaData;
import gov.vha.isaac.ochre.api.component.concept.ConceptSpecification;
import gov.vha.isaac.ochre.api.ConceptProxy;
import gov.vha.isaac.ochre.api.util.UuidT5Generator;

public class PT_Annotations extends BPT_Annotations
{
	public enum Attribute
	{
		CODE(MetaData.CODE),
		ORDER("ICD-10 Order Number");
		
		private final Property property;
		private final String p;

		private Attribute(String niceName)
		{
			// Don't know the owner yet - will be autofilled when we add this to the parent, below.
			property = new Property(null, niceName);
			p = niceName;
		}
		
		private Attribute(ConceptSpecification cs)
		{
			// Don't know the owner yet - will be autofilled when we add this to the parent, below.
			p = cs.getConceptDescriptionText();
			property = new Property(null, cs);
		}

		public Property getProperty()
		{
			return property;
		}
		
		public String get()
		{
			return p; 
		}
	}

	public PT_Annotations(String type)
	{
		super("ICD-10-" + type.toUpperCase());
		for (Attribute attr : Attribute.values())
		{
			addProperty(attr.getProperty());
		}
	}
}
