/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package gov.va.med.term.icd10.mojo;

import org.jvnet.hk2.annotations.Service;
import gov.va.oia.terminology.converters.sharedUtils.config.ConfigOptionsDescriptor;
import gov.vha.isaac.ochre.pombuilder.converter.ConverterOptionParam;
import gov.vha.isaac.ochre.pombuilder.converter.ConverterOptionParamSuggestedValue;

/**
 * 
 * {@link ICD10ConfigOptions}
 *
 * Descriptions of the conversion options that this converter expects, in a form that can be automatically 
 * converted to a json file to be published with the mojo, for easy consumption and eventual inclusion into the 
 * GUI.
 * 
 * @author <a href="mailto:daniel.armbrust.list@gmail.com">Dan Armbrust</a>
 */
@Service
public class ICD10ConfigOptions implements ConfigOptionsDescriptor
{
	public ConverterOptionParam[] getConfigOptions() {
		return new ConverterOptionParam[] { 
			new ConverterOptionParam("Source Type", "sourceType", 
					"The type of ICD10 file that is being processed.  Must be specified and align to the source type being processed.", 
					false, 
					false,
					new ConverterOptionParamSuggestedValue("PCS", "Procedure Coding System"),
					new ConverterOptionParamSuggestedValue("CM", "Clinical Modification"))};
	}

	@Override
	public String getName()
	{
		return "icd10-mojo";
	}
}
