package gov.vha.ctt.ntrt;

import com.atlassian.jira.util.json.JSONObject;
import okhttp3.*;

import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import static gov.vha.ctt.ntrt.SsoiAuthenticator.HEADER_ADSAMACCOUNTNAME;
import static gov.vha.ctt.ntrt.SsoiAuthenticator.HEADER_PRISME_ROLES;
import static java.net.InetAddress.getByName;
import static java.net.InetAddress.getLoopbackAddress;
import static java.util.Collections.singletonList;

class OkHttp extends OkHttpClient {

    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse("application/json; charset=utf-8");

    /**
     *  A trust manager that does not validate certificate chains
     */
    private static final X509TrustManager x509TrustManager = new X509TrustManager() {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };

    static OkHttpClient unsafeClient() throws Exception {
        return unsafeClientBuilder().build();
    }

    private static Builder unsafeClientBuilder() throws NoSuchAlgorithmException, KeyManagementException {

        final SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{x509TrustManager}, new java.security.SecureRandom());

        final SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();

        OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
        builder.sslSocketFactory(sslSocketFactory, x509TrustManager);
        builder.hostnameVerifier((hostname, session) -> true);
        builder.dns(host ->
                host.endsWith(".va.gov") ? singletonList(getLoopbackAddress()) : singletonList(getByName(host)));

        return builder;
    }

    private static OkHttpClient restClient() throws Exception {
        OkHttpClient.Builder builder = unsafeClientBuilder();

        builder.authenticator(new Authenticator() {
            @Nullable
            @Override
            public Request authenticate(Route route, Response response) throws IOException {
                return response.request().newBuilder().header("Authorization", Credentials.basic("admin", "devtesthardtoguess")).build();
            }
        });

        return builder.build();
    }

    private static Request newRestGet(String url) {
        return new Request.Builder()
                .url(url)
                .header(HEADER_PRISME_ROLES, "ntrt_admin")
                .header(HEADER_ADSAMACCOUNTNAME, "admin")
                .build();
    }

    private static Request newRestPut(String url, JSONObject json) {
        return new Request.Builder()
                .url(url)
                .put(RequestBody.create(MEDIA_TYPE_JSON, json.toString()))
                .addHeader("Authentication", Credentials.basic("admin", "devtesthardtoguess"))
                .addHeader("X-ExperimentalApi", "true")
                .build();
    }

    static Response sendRestGet(String url) throws Exception {
        return restClient().newCall(newRestGet(url)).execute();
    }

    static Response sendRestPut(String url, JSONObject json) throws Exception {
        return restClient().newCall(newRestPut(url, json)).execute();
    }
}
