#!/usr/bin/env bash

# define the build directory relative as an absolute path
builddir=$(realpath $(dirname $0)/../)/build

# create the build directory if it doesn't exist
[ ! -d ${builddir} ] && mkdir ${builddir}

# download jira installer
tarball_version=1.0
datasrc=https://DNS              :PORT/nexus/service/local/repositories/ci/content/ntrt/ssoi/jira-application-data/${tarball_version}/jira-application-data-${tarball_version}.bz2
datadest=${builddir}/jira-application-data.bz2
shasrc=${datasrc}.sha1
shadest=${datadest}.sha1

# download the data file only if it's been modified
curl -ksv -u devtest:devtest -z ${datadest} -o ${datadest} ${datasrc}

# always download the checksum
curl -ks -u devtest:devtest -o ${shadest} ${shasrc}

# verify the data file is intact
echo 'Validating sha1 checksum'
echo $(cat ${shadest}) ${datadest} | sha1sum -c -