#!/usr/bin/env bash

basedir=$(realpath $(dirname $0))
rootdir=$(realpath ${basedir}/..)

init () {
    echo '>>> Removing exising files'
    rm -v ${basedir}/apache.* ${basedir}/jira.*
}

make_cert () {

# see https://sysadmin.compxtreme.ro/how-to-deal-with-rsa-server-certificate-is-a-ca-certificate-basicconstraints-ca-true-problem

    echo '>>> Generating Apache certificate'

    # generate private key
    openssl genrsa -des3 -passout pass:apache -out ${basedir}/apache.pass.key 2048
    openssl rsa -passin pass:apache -in ${basedir}/apache.pass.key -out ${basedir}/apache.key

    # generate csr
    openssl req -new -key ${basedir}/apache.key -out ${basedir}/apache.csr -subj "/C=US/ST=VA/L=Herndon/O=CTT/CN=DNS                     "

    # generate certificate
    openssl x509 -req -days 3650 -in ${basedir}/apache.csr -signkey ${basedir}/apache.key -out ${basedir}/apache.crt
}

make_keystore () {

# see:
#   https://hutter.io/2016/02/09/java-create-self-signed-ssl-certificates-for-tomcat/
#   https://stackoverflow.com/a/13578480

    echo '>>> Generating JIRA certificate'

    keytool -genkey -noprompt \
        -alias tomcat \
        -keyalg RSA \
        -validity 365 \
        -dname "C=US, ST=VA, L=Herndon, O=CTT, CN=DNS                     " \
        -keystore ${basedir}/jira.keystore \
        -storepass tomcat \
        -keypass tomcat
}

cleanup () {
    rm ${basedir}/apache.pass.key
    rm ${basedir}/apache.csr
}

deploy () {

    echo '>>> Deploying to jira/build'

    apachedest="${rootdir}/apache/build/"
    [ ! -d ${apachedest} ] && mkdir -v ${apachedest}

    jiradest="${rootdir}/jira/build/"
    [ ! -d ${jiradest} ] && mkdir -v ${jiradest}

    cp -v ${basedir}/apache.* ${apachedest}
    cp -v ${basedir}/apache.crt ${jiradest}
    cp -v ${basedir}/jira.keystore ${jiradest}
}

init
make_cert
make_keystore
cleanup
deploy
