# Introduction

This project produces a custom authentication provider for the NTRT JIRA Service Desk (JSD) implementation, and a customized version of the JIRA login gadget.

## Authenticator

The authenticator associates an incoming SSOi user with an exsiting JSD account. If the account does not exist, one is created for the user based on their NTRT role as indicated in the ```prisme-roles``` header field.

## Custom Login

The login project contains a copy of the login template which is used to render the login form in a stock JSD implementation. Our login template removes the form and replaces it with an error message. 

# Installation

The artifact produced by authenticator (jira-ssoi-authenticator-bin.tar.gz) contains both the authenticator and the login gadget. To deploy it, copy it to the JSD installation directory and untar it there (/opt/atlassian/jira by default, though each system may differ.) This will create a directory named "ssoi" containing the individual deployment artifacts and serveral utility scripts.

Note that a JIRA restart is required for the changes to take effect.

To deploy the artifacts, cd into the ssoi directory and run:

    ./deploy.sh

To remove the SSOi-related files and restore the default configuration, run:

    ./rollback.sh

## Debugging

To enable debugging, run:

    ./debug on

To disable, run:

    ./debug off
