/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package gov.va.isaac.sync.git;

import org.junit.Assert;
import org.junit.Test;
import gov.va.isaac.sync.git.gitblit.GitBlitUtils;

/**
 * {@link GitBlitUtilsTest}
 *
 * @author <a href="mailto:daniel.armbrust.list@gmail.com">Dan Armbrust</a>
 */
public class GitBlitUtilsTest
{
	@Test
	public void TestURLAdjust() throws Exception
	{
		Assert.assertEquals("https://DNS                     :PORT/git/", GitBlitUtils.adjustBareUrlForGitBlit("https://DNS                     :PORT/"));
		Assert.assertEquals("https://DNS:PORT/git/", GitBlitUtils.adjustBareUrlForGitBlit("https://DNS:PORT"));
		Assert.assertEquals("http://DNS                     :PORT/git/", GitBlitUtils.adjustBareUrlForGitBlit("http://DNS                     :PORT/"));
		Assert.assertEquals("http://DNS                     :PORT/git/", GitBlitUtils.adjustBareUrlForGitBlit("http://DNS                     :PORT"));
		Assert.assertEquals("https://DNS                     /git/", GitBlitUtils.adjustBareUrlForGitBlit("https://DNS                     /"));
		Assert.assertEquals("https://DNS                     /git/", GitBlitUtils.adjustBareUrlForGitBlit("https://DNS                     "));
		Assert.assertEquals("https://DNS                     /fred/", GitBlitUtils.adjustBareUrlForGitBlit("https://DNS                     /fred"));
		Assert.assertEquals("https://DNS                     :PORT/git/", GitBlitUtils.adjustBareUrlForGitBlit("https://DNS                     :PORT/git"));
		Assert.assertEquals("https://DNS                     :PORT/git/", GitBlitUtils.adjustBareUrlForGitBlit("https://DNS                     :PORT/git/"));
		Assert.assertEquals("https://DNS                     :PORT/fred/", GitBlitUtils.adjustBareUrlForGitBlit("https://DNS                     :PORT/fred"));
		Assert.assertEquals("https://DNS                     :PORT/fred/", GitBlitUtils.adjustBareUrlForGitBlit("https://DNS                     :PORT/fred/"));
		Assert.assertEquals("HTtps://DNS:PORT/git/", GitBlitUtils.adjustBareUrlForGitBlit("HTtps://DNS:PORT/"));
	}
	
	@Test
	public void TestBaseURLParse() throws Exception
	{
		Assert.assertEquals("https://DNS              :PORT/git/", GitBlitUtils.parseBaseRemoteAddress("https://DNS              :PORT/git/r/db_test.git"));
		Assert.assertEquals("https://DNS              :PORT/git/", GitBlitUtils.parseBaseRemoteAddress("https://DNS              :PORT/git/r/db_test.GIT"));
		Assert.assertEquals("Https://DNS:PORT/git/", GitBlitUtils.parseBaseRemoteAddress("Https://DNS:PORT/git/r/db_-test.git"));
	}
	
	
}
