package gov.vha.isaac.ochre.utility.export;

import static gov.vha.isaac.ochre.api.constants.Constants.DATA_STORE_ROOT_LOCATION_PROPERTY;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.vha.isaac.MetaData;
import gov.vha.isaac.ochre.api.ConfigurationService;
import gov.vha.isaac.ochre.api.Get;
import gov.vha.isaac.ochre.api.LookupService;
import gov.vha.isaac.ochre.api.chronicle.LatestVersion;
import gov.vha.isaac.ochre.api.component.concept.ConceptChronology;
import gov.vha.isaac.ochre.api.component.concept.ConceptService;
import gov.vha.isaac.ochre.api.component.concept.ConceptVersion;
import gov.vha.isaac.ochre.api.component.sememe.SememeChronology;
import gov.vha.isaac.ochre.api.component.sememe.SememeType;
import gov.vha.isaac.ochre.api.component.sememe.version.DescriptionSememe;
import gov.vha.isaac.ochre.api.component.sememe.version.SememeVersion;
import gov.vha.isaac.ochre.api.util.DBLocator;
import gov.vha.isaac.ochre.impl.utility.Frills;
import gov.vha.isaac.ochre.model.configuration.StampCoordinates;
import gov.vha.isaac.ochre.model.sememe.version.ComponentNidSememeImpl;
import gov.vha.isaac.ochre.model.sememe.version.DynamicSememeImpl;
import gov.vha.isaac.ochre.model.sememe.version.StringSememeImpl;

/**
 * 
 * {@link TestConceptExporter}
 *
 * @author <a href="mailto:joel.kniaz.list@gmail.com">Joel Kniaz</a>
 *
 */
public class TestConceptExporter
{

	private static Logger log = LogManager.getLogger();

	public static void main(String[] args)
	{
		//new TestConceptExporter();
		issacInit();
		UUID conceptUuidString = UUID.fromString(args[0]);
		ConceptService conceptService = LookupService.getService(ConceptService.class);
		ConceptChronology<? extends ConceptVersion<?>> conceptChronology = conceptService.getConcept(conceptUuidString);
		//Optional<LatestVersion<ConceptVersion<?>>> optionalLatestVersion = ((ConceptChronology)conceptChronology).getLatestVersion(ConceptVersion.class, StampCoordinates.getDevelopmentLatest());
		//ConceptVersion<?> latestVersion = optionalLatestVersion.get().value();
		List<SememeChronology<? extends DescriptionSememe<?>>> descriptionList = conceptChronology.getConceptDescriptionList();
		System.out.println("DESCRIPTIONS FOR " + Get.conceptDescriptionText(conceptChronology.getNid()));
		for (SememeChronology<? extends DescriptionSememe<?>> descriptionChronology : descriptionList) {
			System.out.println("\tDESC UUID=" + descriptionChronology.getPrimordialUuid());
			int sememeNum = 1;
			System.out.println("\t\tSEMEMES ATTACHED TO DESC:");
			for (SememeChronology<? extends SememeVersion<?>> sememeAttachedToDescription : descriptionChronology.getSememeList()) {
				int currentSememeNum = sememeNum++;
				System.out.println("\t\t\t" + currentSememeNum + " ASSEMBLAGE=" + Get.conceptDescriptionText(sememeAttachedToDescription.getAssemblageSequence()));
				System.out.println("\t\t\t" + currentSememeNum + " SEMEMETYPE=" + sememeAttachedToDescription.getSememeType());
				Optional<LatestVersion<SememeVersion>> optionalLatestSememeVersion = ((SememeChronology)sememeAttachedToDescription).getLatestVersion(SememeVersion.class, StampCoordinates.getDevelopmentLatest());
				SememeVersion<?> sememeVersion = optionalLatestSememeVersion.get().value();
				System.out.println("\t\t\t" + currentSememeNum + "     MODULE=" + Get.conceptDescriptionText(sememeVersion.getModuleSequence()));
				switch(sememeAttachedToDescription.getSememeType()) {
				case COMPONENT_NID:
					System.out.println("\t\t\t" + currentSememeNum + "        TGT=" + Get.conceptDescriptionText(((ComponentNidSememeImpl)sememeVersion).getComponentNid()));
					break;
				case DESCRIPTION:
					break;
				case DYNAMIC:
					break;
				case LOGIC_GRAPH:
					break;
				case LONG:
					break;
				case MEMBER:
					System.out.println("\t\t\t" + currentSememeNum + "      VALUE=" + sememeVersion.toUserString());
					break;
				case RELATIONSHIP_ADAPTOR:
					break;
				case STRING:
					System.out.println("\t\t\t" + currentSememeNum + "       TEXT=" + ((StringSememeImpl)sememeVersion).getString());
					break;
				case UNKNOWN:
					break;
				default:
					break;
					
				}

//				if (sememeAttachedToDescription.getSememeType() == SememeType.STRING) {
//					System.out.println("\t\t\t" + currentSememeNum + " TEXT=" + ((StringSememeImpl)sememeAttachedToDescription).getString());
//				} else if (sememeAttachedToDescription.getSememeType() == SememeType.COMPONENT_NID) {
//					System.out.println("\t\t\t" + currentSememeNum + "  NID=" + sememeAttachedToDescription.toString());
//				} else if (sememeAttachedToDescription.getSememeType() == SememeType.DYNAMIC) {
//					System.out.println("\t\t\t" + currentSememeNum + "  DYN=" + sememeAttachedToDescription.toString());
//				}
			}
			List<? extends DescriptionSememe<?>> versions = descriptionChronology.getVersionList();
			int versionNum = 1;
			System.out.println("\t\tDESCRIPTION " + descriptionChronology.getPrimordialUuid() + " VERSIONS:");
			for (DescriptionSememe<?> version : versions) {
				int currentVersionNum = versionNum++;
				System.out.println("\t\t\t" + currentVersionNum + "  DESC TYPE=" + Get.conceptDescriptionText(version.getDescriptionTypeConceptSequence()));
				System.out.println("\t\t\t" + currentVersionNum + " ASSEMBLAGE=" + Get.conceptDescriptionText(version.getAssemblageSequence()));
				System.out.println("\t\t\t" + currentVersionNum + "     MODULE=" + Get.conceptDescriptionText(version.getModuleSequence()));
				System.out.println("\t\t\t" + currentVersionNum + "      STATE=" + version.getState());
				System.out.println("\t\t\t" + currentVersionNum + "       TEXT=" + version.getText());
			}
			//System.out.println(descriptionChronology.toUserString());
			//System.out.println(descriptionChronology.toString());
		}
		isaacStop();
		javafx.application.Platform.exit();
	}

	private static void issacInit()
	{
		log.info("Isaac Init called");

		try
		{
			log.info("ISAAC Init thread begins");

			if (StringUtils.isBlank(System.getProperty(DATA_STORE_ROOT_LOCATION_PROPERTY)))
			{
				//if there isn't an official system property set, check this one.
				String sysProp = System.getProperty("isaacDatabaseLocation");
				File temp = new File(sysProp);

				File dataStoreLocation = DBLocator.findDBFolder(temp);//temp

				if (!dataStoreLocation.exists())
				{
					throw new RuntimeException("Couldn't find a data store from the input of '" + dataStoreLocation.getAbsoluteFile().getAbsolutePath() + "'");
				}
				if (!dataStoreLocation.isDirectory())
				{
					throw new RuntimeException("The specified data store: '" + dataStoreLocation.getAbsolutePath() + "' is not a folder");
				}

				//use the passed in JVM parameter location
				LookupService.getService(ConfigurationService.class).setDataStoreFolderPath(dataStoreLocation.toPath());
				System.out.println("  Setup AppContext, data store location = " + dataStoreLocation.getAbsolutePath());
			}

			//status_.set("Starting ISAAC");
			LookupService.startupIsaac();

			//status_.set("Ready");
			System.out.println("Done setting up ISAAC");

		}
		catch (Exception e)
		{
			log.error("Failure starting ISAAC", e);
		}
	}

	private static void isaacStop()
	{
		log.info("Stopping ISAAC");
		LookupService.shutdownSystem();
		log.info("ISAAC stopped");
	}
}