package gov.va.rxnorm.propertyTypes;

import java.util.ArrayList;
import java.util.List;

import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.Property;
import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.ValuePropertyPair;
import gov.va.oia.terminology.converters.sharedUtils.umlsUtils.ValuePropertyPairWithAttributes;
import gov.va.rxnorm.rrf.RXNSAT;

public class ValuePropertyPairWithSAB extends ValuePropertyPairWithAttributes
{
	private String sab_;
	private List<RXNSAT> satData_;
	
	public ValuePropertyPairWithSAB(String value, Property property, String sab, List<RXNSAT> satData)
	{
		super(value, property);
		sab_ = sab;
		satData_ = satData;
	}

	@Override
	public int compareTo(ValuePropertyPair o)
	{
		//Boosting descriptions that come from RXNORM up to the very top.
		if (sab_.equals("RXNORM") && !((ValuePropertyPairWithSAB)o).sab_.equals("RXNORM"))
		{
			return -1;
		}
		else if (!sab_.equals("RXNORM") && ((ValuePropertyPairWithSAB)o).sab_.equals("RXNORM"))
		{
			return 1;
		}
		return super.compareTo(o);
	}
	
	public String getSab()
	{
		return sab_;
	}
	
	public List<RXNSAT> getSatData()
	{
		return satData_;
	}
}
