/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package gov.va.med.term.nucc.mojo;

/**
 * 
 * {@link ColumnsV1}
 * 
 * Version 1 Column headers for NUCC import file
 *
 * @author <a href="mailto:joel.kniaz.list@gmail.com">Joel Kniaz</a>
 *
 */
public enum ColumnsV1 {
	Code,
	Grouping,
	Classification,
	Specialization,
	Definition,
	Notes;
	
	final private String columnName;
	
	private ColumnsV1() {
		this(null);
	}
	private ColumnsV1(String name) {
		this.columnName = name != null ? name : name();
	}
	
	public String toString() { return columnName; }
}