require 'logging'
require 'fileutils'

#if nil we are in trinidad
CATALINA_HOME = java.lang.System.properties['catalina.home']
subdir = (File.open('../context.txt').read.reverse.chop.reverse + '/') rescue ''
LOG_HOME = CATALINA_HOME.nil? ? "#{Rails.root}/logs/#{subdir}" : "#{CATALINA_HOME}/logs/#{subdir}"
FileUtils::mkdir_p LOG_HOME

module Logging
  #add a level here if needed....
  RAILS_COMMON_LEVELS = [:trace, :debug, :info, :warn, :error, :fatal, :unknown, :always]
  def self.trace(exception)
    trace_str = "\n"
    if exception.respond_to? :backtrace
      trace_str << exception.to_s << "\n"
      unless exception.backtrace.nil?
        trace_str << exception.backtrace.join("\n")
      end
    end
  end
end
#Logging.caller_tracing=true
Logging.init *Logging::RAILS_COMMON_LEVELS

Logging.color_scheme('pretty',
                     levels: {
                         :info => :green,
                         :warn => :yellow,
                         :error => :red,
                         :fatal => [:white, :on_red],
                         :unknown => [:yellow, :on_blue],
                         :always => :white
                     },
                     date: :yellow,
                     #logger: :cyan,
                     #message: :magenta,
                     file: :magenta,
                     line: :cyan
)
#move pattern to prop file
pattern = $PROPS['LOG.pattern']
Logging.appenders.stdout(
    'stdout',
    :layout => Logging.layouts.pattern(
        :pattern => pattern,
        :color_scheme => 'pretty'
    )
)

rf = Logging.appenders.rolling_file(
    'file',
    layout: Logging.layouts.pattern(
        pattern: pattern,
        color_scheme: 'pretty',
    #    backtrace: true
    ),
    roll_by: $PROPS['LOG.roll_by'],
    keep: $PROPS['LOG.keep'].to_i,
    age: $PROPS['LOG.age'],
    filename: LOG_HOME + $PROPS['LOG.filename'],
    truncate: true
)

begin

  $log = ::Logging::Logger['MainLogger']
  $log.caller_tracing=$PROPS['LOG.caller_tracing'].upcase.eql?('TRUE')

  $log.add_appenders 'stdout' if ($PROPS['LOG.append_stdout'].eql?('true')) # || $rake (ad that in to see log in vadev jenkins build)
  $log.add_appenders rf
  $log.level = $PROPS['LOG.level'].downcase.to_sym

  unless $PROPS['LOG.filename_rails'].nil?

    #rf_rails is for rails logging
    rf_rails = Logging.appenders.rolling_file(
        'file',
        layout: Logging.layouts.pattern(
            pattern: pattern,
            color_scheme: 'pretty',
        #    backtrace: true
        ),
        roll_by: $PROPS['LOG.roll_by'],
        keep: $PROPS['LOG.keep'].to_i,
        age: $PROPS['LOG.age'],
        filename: LOG_HOME + $PROPS['LOG.filename_rails'],
        truncate: true
    )
    $log_rails = ::Logging::Logger['RailsLogger']
    $log_rails.caller_tracing=$PROPS['LOG.caller_tracing'].upcase.eql?('TRUE')

    $log_rails.add_appenders 'stdout' if $PROPS['LOG.append_stdout'].eql?('true')
    $log_rails.add_appenders rf_rails
    $log_rails.level = $PROPS['LOG.level'].downcase.to_sym
  end

  unless $PROPS['LOG.filename_admin'].nil?

    #rf_rails is for rails logging
    rf_admin = Logging.appenders.rolling_file(
        'file',
        layout: Logging.layouts.pattern(
            pattern: pattern,
            color_scheme: 'pretty',
        #    backtrace: true
        ),
        roll_by: $PROPS['LOG.roll_by'],
        keep: $PROPS['LOG.keep'].to_i,
        age: $PROPS['LOG.age'],
        filename: LOG_HOME + $PROPS['LOG.filename_admin'],
        truncate: true
    )
    $alog = ::Logging::Logger['LogAdmin']
    $alog.caller_tracing=$PROPS['LOG.caller_tracing'].upcase.eql?('TRUE')

    $alog.add_appenders 'stdout' if $PROPS['LOG.append_stdout'].eql?('true')
    $alog.add_appenders rf_admin
    $alog.level = $PROPS['LOG.level'].downcase.to_sym
  end

ALL_LOGGERS = [$log, $alog, $log_rails].freeze
# these log messages will be nicely colored
# the level will be colored differently for each message
# PrismeLogEvent not visible yet
  unless (File.basename($0) == 'rake')
    ALL_LOGGERS.each {|e| e.always 'Logging started!' unless e.nil?}
  end
rescue => ex
  warn "Logger failed to initialize.  Reason is #{ex.to_s}"
  warn ex.backtrace.join("\n")
  warn 'Shutting down the KOMET/PRISME web server!'
  java.lang.System.exit(1)
end

#WARNING, using these methods doesn't produce the correct file location in the logs.
ALL_LOGGERS.each do |logger|
  Logging::RAILS_COMMON_LEVELS.each do |level|
    method_name = ("#{level}_e").to_sym
    logger.define_singleton_method(method_name) do |message, exception|
      logger.send(level, message.to_s)
      if exception.respond_to? :backtrace
        logger.send(level, exception.to_s)
        logger.send(level, exception.backtrace.join("\n")) unless exception.backtrace.nil?
      end
    end
  end
end
