package gov.va.med.term.nucc.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

/**
 * 
 * {@link EnumValidatedTableDataReader}
 *
 * Uses a CsvFileReader to process() a passed File,
 * validating contents with respect to a passed COLUMNS Enum,
 * and returning a Terminology object
 *
 * @author <a href="mailto:joel.kniaz.list@gmail.com">Joel Kniaz</a>
 *
 * @param <COLUMNS>
 */
public class EnumValidatedTableDataReader<COLUMNS extends Enum<COLUMNS>>
{	
	private final EnumValidatedCsvFileReader<COLUMNS> fileReader;
	
	private EnumValidatedTableData<COLUMNS> terminology = new EnumValidatedTableData<>();

	public EnumValidatedTableDataReader(
			File inputFileOrDirectory,
			Class<COLUMNS> columnsEnumClass) throws IOException {
		this(inputFileOrDirectory, columnsEnumClass, true, true);
	}
	public EnumValidatedTableDataReader(
			File inputFileOrDirectory,
			Class<COLUMNS> columnsEnumClass,
			boolean headerExists,
			boolean validateHeaderAgainstColumnsEnum) throws IOException
	{		
		File file = null;
		if (inputFileOrDirectory.isDirectory())
		{
			ArrayList<File> files = new ArrayList<File>();
			for (File f : inputFileOrDirectory.listFiles())
			{
				if (f.isFile()
						&& (f.getName().toLowerCase().endsWith(".csv")))
				{
					files.add(f);
				}
			}
			
			if (files.size() != 1)
			{
				throw new RuntimeException(files.size() + " csv files were found inside of " + inputFileOrDirectory.getAbsolutePath() 
						+ " but this implementation requires 1 and only 1 csv file to be present.");
			}
			
			file = files.get(0);
		}
		else
		{
			file = inputFileOrDirectory;
		}

		System.out.println("Prepared to process: " + file.getAbsolutePath());

		this.fileReader = new EnumValidatedCsvFileReader<>(file, columnsEnumClass, headerExists, validateHeaderAgainstColumnsEnum);
	}

	public EnumValidatedTableData<COLUMNS> process() throws IOException
	{
		try {
			for (Map<COLUMNS, String> row = fileReader.readLineAsMap(); row != null; row = fileReader.readLineAsMap()) {
				terminology.rows().add(row);
			}
			return terminology;
		} finally {
			close();
		}
	}
	
	public void close() throws IOException {
		fileReader.close();
	}
}